/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.outlier.detector.http;

import com.tencent.polaris.api.config.consumer.OutlierDetectionConfig;
import com.tencent.polaris.api.config.plugin.PluginConfigProvider;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.detect.HealthChecker;
import com.tencent.polaris.api.pojo.DetectResult;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.outlier.detector.http.Config;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;

public class HttpHealthChecker
implements HealthChecker,
PluginConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HttpHealthChecker.class);
    private static final int EXPECT_CODE = 200;
    private Config config;

    public DetectResult detectInstance(Instance instance) throws PolarisException {
        try {
            String pattern = this.config.getPath();
            String path = String.format("http://%s:%d%s", instance.getHost(), instance.getPort(), pattern);
            URL url = new URL(path);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(this.config.getTimeout().intValue());
            conn.setReadTimeout(this.config.getTimeout().intValue());
            if (conn.getResponseCode() == 200) {
                return new DetectResult(RetStatus.RetSuccess);
            }
            return new DetectResult(RetStatus.RetFail);
        }
        catch (Exception e) {
            LOG.warn("http detect exception, service:{}, host:{}, port:{}.", new Object[]{instance.getService(), instance.getHost(), instance.getPort()});
            return new DetectResult(RetStatus.RetFail);
        }
    }

    public Class<? extends Verifier> getPluginConfigClazz() {
        return Config.class;
    }

    public String getName() {
        return "http";
    }

    public PluginType getType() {
        return PluginTypes.HEALTH_CHECKER.getBaseType();
    }

    public void init(InitContext ctx) throws PolarisException {
        OutlierDetectionConfig outlierDetection = ctx.getConfig().getConsumer().getOutlierDetection();
        Config cfg = (Config)outlierDetection.getPluginConfig(this.getName(), Config.class);
        if (cfg == null) {
            throw new PolarisException(ErrorCode.INVALID_CONFIG, String.format("plugin %s config is missing", this.getName()));
        }
        this.config = cfg;
    }

    public void postContextInit(Extensions extensions) throws PolarisException {
    }

    public void destroy() {
    }
}

