/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.context.config;

import com.tencent.cloud.polaris.context.ConditionalOnPolarisEnabled;
import com.tencent.cloud.polaris.context.ModifyAddress;
import com.tencent.cloud.polaris.context.PolarisConfigModifier;
import com.tencent.cloud.polaris.context.PolarisSDKContextManager;
import com.tencent.cloud.polaris.context.ServiceRuleManager;
import com.tencent.cloud.polaris.context.config.PolarisContextProperties;
import com.tencent.polaris.api.exception.PolarisException;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@ConditionalOnPolarisEnabled
@EnableConfigurationProperties(value={PolarisContextProperties.class})
public class PolarisContextAutoConfiguration {
    @Bean(initMethod="init")
    @ConditionalOnMissingBean
    public PolarisSDKContextManager polarisSDKContextManager(PolarisContextProperties properties, Environment environment, List<PolarisConfigModifier> modifierList) throws PolarisException {
        return new PolarisSDKContextManager(properties, environment, modifierList);
    }

    @Bean
    @ConditionalOnMissingBean
    public ModifyAddress polarisConfigModifier(PolarisContextProperties properties) {
        return new ModifyAddress(properties);
    }

    @Bean
    public ServiceRuleManager serviceRuleManager(PolarisSDKContextManager polarisSDKContextManager) {
        return new ServiceRuleManager(polarisSDKContextManager.getSDKContext(), polarisSDKContextManager.getConsumerAPI());
    }
}

