/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.context;

import com.tencent.cloud.polaris.context.PolarisConfigModifier;
import com.tencent.cloud.polaris.context.config.PolarisContextProperties;
import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.core.ProviderAPI;
import com.tencent.polaris.assembly.api.AssemblyAPI;
import com.tencent.polaris.assembly.factory.AssemblyAPIFactory;
import com.tencent.polaris.circuitbreak.api.CircuitBreakAPI;
import com.tencent.polaris.circuitbreak.factory.CircuitBreakAPIFactory;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.factory.api.DiscoveryAPIFactory;
import com.tencent.polaris.factory.api.RouterAPIFactory;
import com.tencent.polaris.ratelimit.api.core.LimitAPI;
import com.tencent.polaris.ratelimit.factory.LimitAPIFactory;
import com.tencent.polaris.router.api.core.RouterAPI;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class PolarisSDKContextManager {
    private static final Logger LOG = LoggerFactory.getLogger(PolarisSDKContextManager.class);
    public static volatile boolean isRegistered = false;
    private static volatile SDKContext sdkContext;
    private static volatile ProviderAPI providerAPI;
    private static volatile ConsumerAPI consumerAPI;
    private static volatile RouterAPI routerAPI;
    private static volatile CircuitBreakAPI circuitBreakAPI;
    private static volatile LimitAPI limitAPI;
    private static volatile AssemblyAPI assemblyAPI;
    private final PolarisContextProperties properties;
    private final Environment environment;
    private final List<PolarisConfigModifier> modifierList;

    public PolarisSDKContextManager(PolarisContextProperties properties, Environment environment, List<PolarisConfigModifier> modifierList) {
        this.properties = properties;
        this.environment = environment;
        this.modifierList = modifierList;
    }

    public static void innerDestroy() {
        if (Objects.nonNull(sdkContext)) {
            try {
                if (Objects.nonNull(providerAPI)) {
                    providerAPI.close();
                    providerAPI = null;
                }
                if (Objects.nonNull(consumerAPI)) {
                    consumerAPI.close();
                    consumerAPI = null;
                }
                if (Objects.nonNull(routerAPI)) {
                    ((Destroyable)routerAPI).destroy();
                    routerAPI = null;
                }
                if (Objects.nonNull(circuitBreakAPI)) {
                    ((Destroyable)circuitBreakAPI).destroy();
                    circuitBreakAPI = null;
                }
                if (Objects.nonNull(limitAPI)) {
                    limitAPI.close();
                    limitAPI = null;
                }
                if (Objects.nonNull(assemblyAPI)) {
                    ((Destroyable)assemblyAPI).destroy();
                    assemblyAPI = null;
                }
                if (Objects.nonNull(sdkContext)) {
                    sdkContext.destroy();
                    sdkContext = null;
                }
                LOG.info("Polaris SDK context is destroyed.");
            }
            catch (Throwable throwable) {
                LOG.error("destroy Polaris SDK context failed.", throwable);
            }
        }
    }

    public void init() {
        if (null == sdkContext) {
            try {
                sdkContext = SDKContext.initContextByConfig((Configuration)this.properties.configuration(this.modifierList, () -> this.environment.getProperty("spring.cloud.client.ip-address"), () -> (Integer)this.environment.getProperty("spring.cloud.polaris.local-port", Integer.class, (Object)0)));
                sdkContext.init();
                providerAPI = DiscoveryAPIFactory.createProviderAPIByContext((SDKContext)sdkContext);
                consumerAPI = DiscoveryAPIFactory.createConsumerAPIByContext((SDKContext)sdkContext);
                routerAPI = RouterAPIFactory.createRouterAPIByContext((SDKContext)sdkContext);
                circuitBreakAPI = CircuitBreakAPIFactory.createCircuitBreakAPIByContext((SDKContext)sdkContext);
                limitAPI = LimitAPIFactory.createLimitAPIByContext((SDKContext)sdkContext);
                assemblyAPI = AssemblyAPIFactory.createAssemblyAPIByContext((SDKContext)sdkContext);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    long startTimestamp = System.currentTimeMillis();
                    long delay = 0L;
                    while (true) {
                        if (!isRegistered || delay >= 60000L) break;
                        delay = System.currentTimeMillis() - startTimestamp;
                    }
                    PolarisSDKContextManager.innerDestroy();
                }));
                LOG.info("create Polaris SDK context successfully. properties: {}", (Object)this.properties);
            }
            catch (Throwable throwable) {
                LOG.error("create Polaris SDK context failed. properties: {}", (Object)this.properties, (Object)throwable);
                throw throwable;
            }
        }
    }

    public SDKContext getSDKContext() {
        this.init();
        return sdkContext;
    }

    public ProviderAPI getProviderAPI() {
        this.init();
        return providerAPI;
    }

    public ConsumerAPI getConsumerAPI() {
        this.init();
        return consumerAPI;
    }

    public RouterAPI getRouterAPI() {
        this.init();
        return routerAPI;
    }

    public CircuitBreakAPI getCircuitBreakAPI() {
        this.init();
        return circuitBreakAPI;
    }

    public LimitAPI getLimitAPI() {
        this.init();
        return limitAPI;
    }

    public AssemblyAPI getAssemblyAPI() {
        return assemblyAPI;
    }
}

