/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.ws.InFlightRequest;
import com.taosdata.jdbc.ws.ResponseFuture;
import com.taosdata.jdbc.ws.WSClient;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.entity.Response;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;

public class Transport
implements AutoCloseable {
    public static final int DEFAULT_MAX_REQUEST = 100;
    public static final int DEFAULT_MESSAGE_WAIT_TIMEOUT = 3000;
    private final WSClient client;
    private final InFlightRequest inFlightRequest;

    public Transport(WSClient client, InFlightRequest inFlightRequest) {
        this.client = client;
        this.inFlightRequest = inFlightRequest;
    }

    public CompletableFuture<Response> send(Request request) {
        CompletableFuture<Response> completableFuture = new CompletableFuture<Response>();
        try {
            this.inFlightRequest.put(new ResponseFuture(request.getAction(), request.id(), completableFuture));
            this.client.send(request.toString());
        }
        catch (Throwable t) {
            this.inFlightRequest.remove(request.getAction(), request.id());
            completableFuture.completeExceptionally(t);
        }
        return completableFuture;
    }

    public void sendWithoutRep(Request request) {
        this.client.send(request.toString());
    }

    public boolean isClosed() throws SQLException {
        return this.client.isClosed();
    }

    @Override
    public void close() throws SQLException {
        this.client.close();
    }
}

