/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.pipe;

import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.ContainerResolver;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class Engine {
    private volatile Executor threadPool;
    public final String id;
    private final Container container;

    public Engine(String id, Container container, Executor threadPool) {
        this(id, container);
        this.threadPool = threadPool;
    }

    public Engine(String id, Container container) {
        this.id = id;
        this.container = container;
    }

    public void setExecutor(Executor threadPool) {
        this.threadPool = this.wrap(threadPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRunnable(Fiber fiber) {
        if (this.threadPool == null) {
            Engine engine = this;
            synchronized (engine) {
                this.threadPool = this.wrap(Executors.newCachedThreadPool(new DaemonThreadFactory()));
            }
        }
        this.threadPool.execute(fiber);
    }

    private Executor wrap(Executor ex) {
        return ContainerResolver.getDefault().wrapExecutor(this.container, ex);
    }

    public Fiber createFiber() {
        return new Fiber(this);
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        DaemonThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "jaxws-engine-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

