/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.application;

import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.api.core.HttpResponseContext;
import com.sun.jersey.api.uri.ExtendedUriInfo;
import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.api.uri.UriTemplate;
import com.sun.jersey.impl.MultivaluedMapImpl;
import com.sun.jersey.impl.application.WebApplicationImpl;
import com.sun.jersey.impl.model.ResourceClass;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.uri.rules.UriRule;
import com.sun.jersey.spi.uri.rules.UriRuleContext;
import com.sun.jersey.spi.uri.rules.UriRules;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebApplicationContext
implements UriRuleContext,
ExtendedUriInfo {
    private final ContainerRequest request;
    private final ContainerResponse response;
    private final WebApplicationImpl app;
    private Map<String, Object> properties;
    private MatchResult matchResult;
    private final LinkedList<Object> resources = new LinkedList();
    private final LinkedList<MatchResult> matchResults = new LinkedList();
    private final LinkedList<String> paths = new LinkedList();
    private final LinkedList<UriTemplate> templates = new LinkedList();
    private MultivaluedMapImpl encodedTemplateValues;
    private MultivaluedMapImpl decodedTemplateValues;

    public WebApplicationContext(WebApplicationImpl app, ContainerRequest request, ContainerResponse response) {
        this.app = app;
        this.request = request;
        this.response = response;
    }

    public HttpRequestContext getRequest() {
        return this.request;
    }

    public HttpResponseContext getResponse() {
        return this.response;
    }

    public ExtendedUriInfo getUriInfo() {
        return this;
    }

    public Map<String, Object> getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        this.properties = new HashMap<String, Object>();
        return this.properties;
    }

    @Override
    public MatchResult getMatchResult() {
        return this.matchResult;
    }

    @Override
    public void setMatchResult(MatchResult matchResult) {
        this.matchResult = matchResult;
    }

    @Override
    public Object getResource(Class resourceClass) {
        ResourceClass rc = this.app.getResourceClass(resourceClass);
        return rc.provider.getInstance(this.app.getResourceComponentProvider(), this);
    }

    @Override
    public UriRules<UriRule> getRules(Class resourceClass) {
        ResourceClass rc = this.app.getResourceClass(resourceClass);
        return rc.getRules();
    }

    @Override
    public void pushParameterValues(List<String> names) {
        if (this.encodedTemplateValues == null) {
            this.encodedTemplateValues = new MultivaluedMapImpl();
        }
        int i = 1;
        for (String name : names) {
            String value = this.matchResult.group(i++);
            this.encodedTemplateValues.addFirst(name, value);
            if (this.decodedTemplateValues == null) continue;
            this.decodedTemplateValues.addFirst(UriComponent.decode((String)name, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT), UriComponent.decode((String)value, (UriComponent.Type)UriComponent.Type.PATH));
        }
        this.matchResults.addFirst(this.matchResult);
    }

    @Override
    public void pushResource(Object resource, UriTemplate template) {
        this.resources.addFirst(resource);
        this.templates.addFirst(template);
    }

    @Override
    public void pushRightHandPathLength(int rhpathlen) {
        String ep = this.request.getPath(false);
        this.paths.addFirst(ep.substring(0, ep.length() - rhpathlen));
    }

    public URI getBaseUri() {
        return this.request.getBaseUri();
    }

    public UriBuilder getBaseUriBuilder() {
        return this.request.getBaseUriBuilder();
    }

    public URI getAbsolutePath() {
        return this.request.getAbsolutePath();
    }

    public UriBuilder getAbsolutePathBuilder() {
        return this.request.getAbsolutePathBuilder();
    }

    public URI getRequestUri() {
        return this.request.getRequestUri();
    }

    public UriBuilder getRequestUriBuilder() {
        return this.request.getRequestUriBuilder();
    }

    public String getPath() {
        return this.request.getPath(true);
    }

    public String getPath(boolean decode) {
        return this.request.getPath(decode);
    }

    public List<PathSegment> getPathSegments() {
        return this.request.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        return this.request.getPathSegments(decode);
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.request.getQueryParameters(true);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        return this.request.getQueryParameters(decode);
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        if (decode) {
            if (this.decodedTemplateValues != null) {
                return this.decodedTemplateValues;
            }
            this.decodedTemplateValues = new MultivaluedMapImpl();
            for (Map.Entry e : this.encodedTemplateValues.entrySet()) {
                ArrayList<String> l = new ArrayList<String>();
                for (String v : (List)e.getValue()) {
                    l.add(UriComponent.decode((String)v, (UriComponent.Type)UriComponent.Type.PATH));
                }
                this.decodedTemplateValues.put((Object)UriComponent.decode((String)((String)e.getKey()), (UriComponent.Type)UriComponent.Type.PATH_SEGMENT), l);
            }
            return this.decodedTemplateValues;
        }
        return this.encodedTemplateValues;
    }

    public List<String> getMatchedURIs() {
        return this.paths;
    }

    public List<String> getMatchedURIs(boolean decode) {
        throw new UnsupportedOperationException();
    }

    public List<Object> getMatchedResources() {
        return this.resources;
    }

    public List<MatchResult> getMatchedResults() {
        return this.matchResults;
    }

    public List<UriTemplate> getMatchedTemplates() {
        return this.templates;
    }

    public List<PathSegment> getPathSegments(String name) {
        return this.getPathSegments(name, true);
    }

    public List<PathSegment> getPathSegments(String name, boolean decode) {
        int[] bounds = this.getPathParameterBounds(name);
        if (bounds != null) {
            String path = this.matchResults.getLast().group();
            int segmentsStart = 0;
            for (int x = 0; x < bounds[0]; ++x) {
                if (path.charAt(x) != '/') continue;
                ++segmentsStart;
            }
            int segmentsEnd = segmentsStart;
            for (int x = bounds[0]; x < bounds[1]; ++x) {
                if (path.charAt(x) != '/') continue;
                ++segmentsEnd;
            }
            return this.getPathSegments(decode).subList(segmentsStart - 1, segmentsEnd);
        }
        return Collections.emptyList();
    }

    private int[] getPathParameterBounds(String name) {
        Iterator iTemplate = this.templates.iterator();
        Iterator iMatchResult = this.matchResults.iterator();
        while (iTemplate.hasNext()) {
            MatchResult mr = (MatchResult)iMatchResult.next();
            int pIndex = this.getLastPathParameterIndex(name, (UriTemplate)iTemplate.next());
            if (pIndex == -1) continue;
            int pathLength = mr.group().length();
            int segmentIndex = mr.end(pIndex + 1);
            int groupLength = segmentIndex - mr.start(pIndex + 1);
            while (iMatchResult.hasNext()) {
                mr = (MatchResult)iMatchResult.next();
                segmentIndex += mr.group().length() - pathLength;
                pathLength = mr.group().length();
            }
            int[] bounds = new int[]{segmentIndex - groupLength, segmentIndex};
            return bounds;
        }
        return null;
    }

    private int getLastPathParameterIndex(String name, UriTemplate t) {
        int i = 0;
        int pIndex = -1;
        for (String parameterName : t.getTemplateVariables()) {
            if (parameterName.equals(name)) {
                pIndex = i;
            }
            ++i;
        }
        return pIndex;
    }
}

