/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.container.filter;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class GZIPContentEncodingFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public ContainerRequest filter(ContainerRequest request) {
        if (request.getRequestHeaders().containsKey((Object)"Content-Encoding") && ((String)request.getRequestHeaders().getFirst((Object)"Content-Encoding")).trim().equals("gzip")) {
            request.getRequestHeaders().remove((Object)"Content-Encoding");
            try {
                request.setEntityInputStream(new GZIPInputStream(request.getEntityInputStream()));
            }
            catch (IOException ex) {
                throw new ContainerException((Throwable)ex);
            }
        }
        return request;
    }

    public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
        if (response.getEntity() != null && request.getRequestHeaders().containsKey((Object)"Accept-Encoding") && !response.getHttpHeaders().containsKey((Object)"Content-Encoding") && ((String)request.getRequestHeaders().getFirst((Object)"Accept-Encoding")).contains("gzip")) {
            response.getHttpHeaders().add((Object)"Content-Encoding", (Object)"gzip");
            response.setContainerResponseWriter(new Adapter(response.getContainerResponseWriter()));
        }
        return response;
    }

    private static final class Adapter
    implements ContainerResponseWriter {
        private final ContainerResponseWriter crw;
        private GZIPOutputStream gos;

        Adapter(ContainerResponseWriter crw) {
            this.crw = crw;
        }

        public OutputStream writeStatusAndHeaders(long contentLength, ContainerResponse response) throws IOException {
            this.gos = new GZIPOutputStream(this.crw.writeStatusAndHeaders(-1L, response));
            return this.gos;
        }

        public void finish() throws IOException {
            this.gos.finish();
        }
    }
}

