/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.container.servlet;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.servlet.WebComponent;
import com.sun.jersey.spi.container.servlet.WebConfig;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContainer
extends WebComponent
implements Servlet,
ServletConfig,
Filter,
Serializable {
    private transient ServletConfig servletConfig;
    private transient FilterConfig filterConfig;

    public String getServletName() {
        return this._getServletConfig().getServletName();
    }

    public ServletContext getServletContext() {
        return this._getServletConfig().getServletContext();
    }

    public String getInitParameter(String name) {
        return this._getServletConfig().getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this._getServletConfig().getInitParameterNames();
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    private ServletConfig _getServletConfig() {
        if (this.servletConfig == null) {
            throw new IllegalStateException("Servlet is not initialized");
        }
        return this.servletConfig;
    }

    public String getServletInfo() {
        return "";
    }

    public final void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        this.init(new WebConfig(){

            @Override
            public String getName() {
                return ServletContainer.this.servletConfig.getServletName();
            }

            @Override
            public String getInitParameter(String name) {
                return ServletContainer.this.servletConfig.getInitParameter(name);
            }

            @Override
            public Enumeration getInitParameterNames() {
                return ServletContainer.this.servletConfig.getInitParameterNames();
            }

            @Override
            public ServletContext getServletContext() {
                return ServletContainer.this.servletConfig.getServletContext();
            }

            @Override
            public ResourceConfig getDefaultResourceConfig(Map<String, Object> props) throws ServletException {
                return ServletContainer.this.getDefaultResourceConfig(props, ServletContainer.this.servletConfig);
            }
        });
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        try {
            this.service((HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (ClassCastException e) {
            throw new ServletException("non-HTTP request or response");
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String encodedBasePath;
        if (request.getPathInfo() != null && request.getPathInfo().equals("/") && !request.getRequestURI().endsWith("/")) {
            response.setStatus(404);
            return;
        }
        UriBuilder absoluteUriBuilder = UriBuilder.fromUri((String)request.getRequestURL().toString());
        String decodedBasePath = request.getPathInfo() != null ? request.getContextPath() + request.getServletPath() + "/" : request.getContextPath() + "/";
        if (!decodedBasePath.equals(encodedBasePath = UriComponent.encode((String)decodedBasePath, (UriComponent.Type)UriComponent.Type.PATH))) {
            throw new ContainerException("The servlet context path and/or the servlet path contain characters that are percent enocded");
        }
        URI baseUri = absoluteUriBuilder.replacePath(encodedBasePath).build(new Object[0]);
        String queryParameters = request.getQueryString();
        if (queryParameters == null) {
            queryParameters = "";
        }
        URI requestUri = absoluteUriBuilder.replacePath(request.getRequestURI()).replaceQuery(queryParameters).build(new Object[0]);
        this.service(baseUri, requestUri, request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.init(new WebConfig(){

            @Override
            public String getName() {
                return ServletContainer.this.filterConfig.getFilterName();
            }

            @Override
            public String getInitParameter(String name) {
                return ServletContainer.this.filterConfig.getInitParameter(name);
            }

            @Override
            public Enumeration getInitParameterNames() {
                return ServletContainer.this.filterConfig.getInitParameterNames();
            }

            @Override
            public ServletContext getServletContext() {
                return ServletContainer.this.filterConfig.getServletContext();
            }

            @Override
            public ResourceConfig getDefaultResourceConfig(Map<String, Object> props) throws ServletException {
                return null;
            }
        });
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
        }
        catch (ClassCastException e) {
            throw new ServletException("non-HTTP request or response");
        }
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        UriBuilder absoluteUriBuilder = UriBuilder.fromUri((String)request.getRequestURL().toString());
        URI baseUri = absoluteUriBuilder.replacePath(request.getContextPath()).path("/").build(new Object[0]);
        URI requestUri = absoluteUriBuilder.replacePath(request.getRequestURI()).replaceQuery(request.getQueryString()).build(new Object[0]);
        this.service(baseUri, requestUri, request, response);
    }

    protected void configure(ServletConfig sc, ResourceConfig rc, WebApplication wa) {
        rc.getSingletons().add(new WebComponent.ContextInjectableProvider<ServletConfig>((Type)((Object)ServletConfig.class), sc));
    }

    protected void configure(FilterConfig fc, ResourceConfig rc, WebApplication wa) {
        rc.getSingletons().add(new WebComponent.ContextInjectableProvider<FilterConfig>((Type)((Object)FilterConfig.class), fc));
    }

    @Override
    protected void configure(WebConfig wc, ResourceConfig rc, WebApplication wa) {
        super.configure(wc, rc, wa);
        if (this.servletConfig != null) {
            this.configure(this.servletConfig, rc, wa);
        } else if (this.filterConfig != null) {
            this.configure(this.filterConfig, rc, wa);
        }
    }

    @Deprecated
    protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, ServletConfig servletConfig) throws ServletException {
        return this.getDefaultResourceConfig(props, this.getWebConfig());
    }
}

