/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.multipart;

import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.BodyPartEntity;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormDataBodyPart
extends BodyPart {
    private String name = null;

    public FormDataBodyPart() {
        this(new MediaType("text", "plain"));
    }

    public FormDataBodyPart(MediaType mediaType) {
        super(mediaType);
    }

    public FormDataBodyPart(Object entity, MediaType mediaType) {
        super(entity, mediaType);
    }

    public FormDataBodyPart(String name, String value) {
        super(value, MediaType.TEXT_PLAIN_TYPE);
        this.setName(name);
    }

    public FormDataBodyPart(String name, Object entity, MediaType mediaType) {
        super(entity, mediaType);
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        if (!MediaType.TEXT_PLAIN_TYPE.equals((Object)this.getMediaType())) {
            throw new IllegalStateException("Media type is not text/plain");
        }
        if (this.getEntity() instanceof BodyPartEntity) {
            StringBuilder sb = new StringBuilder();
            try {
                InputStreamReader reader = new InputStreamReader(((BodyPartEntity)this.getEntity()).getInputStream());
                int ch = 0;
                while ((ch = reader.read()) >= 0) {
                    sb.append((char)ch);
                }
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sb.toString();
        }
        return (String)this.getEntity();
    }

    public <T> T getValueAs(Class<T> clazz) {
        return this.getEntityAs(clazz);
    }

    public boolean isSimple() {
        return MediaType.TEXT_PLAIN_TYPE.equals((Object)this.getMediaType());
    }

    public void setName(String name) {
        this.name = name;
        if (this.getHeaders().get((Object)"Content-Disposition") == null) {
            this.getHeaders().putSingle((Object)"Content-Disposition", (Object)("form-data; name=\"" + name + "\""));
        }
    }

    public void setValue(String value) {
        if (!MediaType.TEXT_PLAIN_TYPE.equals((Object)this.getMediaType())) {
            throw new IllegalStateException("Media type is not text/plain");
        }
        this.setEntity(value);
    }

    public void setValue(MediaType mediaType, Object value) {
        this.setMediaType(mediaType);
        this.setEntity(value);
    }
}

