/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.DefaultSelectionKeyHandler;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.StatsThreadPool;
import com.sun.grizzly.util.Copyable;
import com.sun.grizzly.util.SelectionKeyAttachment;
import java.nio.channels.SelectionKey;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorThreadKeyHandler
extends DefaultSelectionKeyHandler {
    private SelectorThread selectorThread;

    public SelectorThreadKeyHandler() {
    }

    public SelectorThreadKeyHandler(SelectorThread selectorThread) {
        this.selectorThread = selectorThread;
    }

    public void copyTo(Copyable copy) {
        super.copyTo(copy);
        SelectorThreadKeyHandler copyHandler = (SelectorThreadKeyHandler)copy;
        copyHandler.selectorThread = this.selectorThread;
    }

    public void cancel(SelectionKey key) {
        if (key != null) {
            if (this.selectorThread.getThreadPool() instanceof StatsThreadPool && this.selectorThread.isMonitoringEnabled() && ((StatsThreadPool)((Object)this.selectorThread.getThreadPool())).getStatistic().decrementOpenConnectionsCount(key.channel())) {
                this.selectorThread.getRequestGroupInfo().decreaseCountOpenConnections();
            }
            super.cancel(key);
        }
    }

    public void doRegisterKey(SelectionKey key, int ops, long currentTime) {
        Object attachment = key.attachment();
        if (attachment != null && attachment.equals(-9223372036854775807L)) {
            return;
        }
        if (!key.isValid()) {
            this.selectorHandler.getSelectionKeyHandler().cancel(key);
        } else {
            key.interestOps(key.interestOps() | ops);
            this.addExpirationStamp(key, currentTime);
        }
    }

    public void expire(Iterator<SelectionKey> iterator) {
        if (this.timeout == Long.MIN_VALUE) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime < this.nextKeysExpiration) {
            return;
        }
        this.nextKeysExpiration = currentTime + 1000L;
        while (iterator.hasNext()) {
            long idleLimit;
            long expire;
            Object attachment;
            SelectionKey key = iterator.next();
            if (!key.isValid() || (attachment = key.attachment()) == null || (expire = this.getExpirationStamp(attachment)) < 0L || (idleLimit = this.getIdleLimit(attachment)) < 0L || currentTime - expire < idleLimit || attachment instanceof SelectionKeyAttachment && !((SelectionKeyAttachment)attachment).timedOut(key)) continue;
            this.addExpirationStamp(key, Long.MIN_VALUE);
            this.cancel(key);
        }
    }

    private long getIdleLimit(Object attachment) {
        long idleLimit;
        if (attachment instanceof SelectionKeyAttachment && (idleLimit = ((SelectionKeyAttachment)attachment).getIdleTimeoutDelay()) != -9223372036854775806L) {
            return idleLimit;
        }
        return this.timeout;
    }
}

