/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.future;

import com.spotify.hamcrest.future.Utils;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class SuccessfullyCompletedFuture<T>
extends TypeSafeDiagnosingMatcher<Future<? extends T>> {
    private final Matcher<T> matcher;

    SuccessfullyCompletedFuture(Matcher<T> matcher) {
        this.matcher = Objects.requireNonNull(matcher);
    }

    protected boolean matchesSafely(Future<? extends T> future, Description mismatchDescription) {
        if (future.isDone()) {
            if (future.isCancelled()) {
                mismatchDescription.appendText("a future that was cancelled");
                return false;
            }
            try {
                T item = future.get();
                if (this.matcher.matches(item)) {
                    return true;
                }
                mismatchDescription.appendText("a future that completed to a value that ");
                this.matcher.describeMismatch(item, mismatchDescription);
                return false;
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)"This should never happen because the future is completed.");
            }
            catch (ExecutionException e) {
                mismatchDescription.appendText("a future that completed exceptionally with ").appendText(Utils.getStackTraceAsString(e.getCause()));
                return false;
            }
        }
        mismatchDescription.appendText("a future that was not completed");
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("a future that completed to a value that ").appendDescriptionOf(this.matcher);
    }
}

