/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.future;

import com.spotify.hamcrest.future.Utils;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class SuccessfullyCompletedCompletionStage<T>
extends TypeSafeDiagnosingMatcher<CompletionStage<? extends T>> {
    private final Matcher<T> matcher;

    SuccessfullyCompletedCompletionStage(Matcher<T> matcher) {
        this.matcher = Objects.requireNonNull(matcher);
    }

    protected boolean matchesSafely(CompletionStage<? extends T> stage, Description mismatchDescription) {
        CompletableFuture<T> future = stage.toCompletableFuture();
        if (future.isDone()) {
            if (future.isCancelled()) {
                mismatchDescription.appendText("a stage that was cancelled");
                return false;
            }
            if (future.isCompletedExceptionally()) {
                try {
                    future.getNow(null);
                    throw new AssertionError((Object)"This should never happen because the future has completed exceptionally.");
                }
                catch (CompletionException e) {
                    mismatchDescription.appendText("a stage that completed exceptionally with ").appendText(Utils.getStackTraceAsString(e.getCause()));
                    return false;
                }
            }
            Object item = future.getNow(null);
            if (this.matcher.matches(item)) {
                return true;
            }
            mismatchDescription.appendText("a stage that completed to a value that ");
            this.matcher.describeMismatch(item, mismatchDescription);
            return false;
        }
        mismatchDescription.appendText("a stage that was not done");
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("a stage that completed to a value that ").appendDescriptionOf(this.matcher);
    }
}

