/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.future;

import com.spotify.hamcrest.future.Utils;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class SuccessfullyCompletedBlockingCompletionStage<T>
extends TypeSafeDiagnosingMatcher<CompletionStage<? extends T>> {
    private final Matcher<T> matcher;

    SuccessfullyCompletedBlockingCompletionStage(Matcher<T> matcher) {
        this.matcher = Objects.requireNonNull(matcher);
    }

    protected boolean matchesSafely(CompletionStage<? extends T> future, Description mismatchDescription) {
        try {
            T item = future.toCompletableFuture().get();
            if (this.matcher.matches(item)) {
                return true;
            }
            mismatchDescription.appendText("a stage that completed with a value that ");
            this.matcher.describeMismatch(item, mismatchDescription);
            return false;
        }
        catch (InterruptedException e) {
            mismatchDescription.appendText("a stage that was interrupted");
            return false;
        }
        catch (ExecutionException e) {
            mismatchDescription.appendText("a stage that completed exceptionally with ").appendText(Utils.getStackTraceAsString(e.getCause()));
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText("a stage that completed with a value that ").appendDescriptionOf(this.matcher);
    }
}

