/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.future;

import com.spotify.hamcrest.future.ExceptionallyCompletedBlockingFuture;
import com.spotify.hamcrest.future.ExceptionallyCompletedFuture;
import com.spotify.hamcrest.future.SuccessfullyCompletedBlockingFuture;
import com.spotify.hamcrest.future.SuccessfullyCompletedFuture;
import java.util.concurrent.Future;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class FutureMatchers {
    private FutureMatchers() {
    }

    public static <T> Matcher<Future<T>> futureCompletedWithException() {
        return FutureMatchers.futureCompletedWithExceptionThat((Matcher<? extends Throwable>)CoreMatchers.any(Throwable.class));
    }

    public static <T> Matcher<Future<T>> futureCompletedWithExceptionThat(Matcher<? extends Throwable> matcher) {
        return new ExceptionallyCompletedFuture(matcher);
    }

    public static Matcher<Future<?>> futureCompletedWithValue() {
        return FutureMatchers.futureCompletedWithValueThat(CoreMatchers.anything());
    }

    public static <T> Matcher<Future<? extends T>> futureCompletedWithValueThat(Matcher<T> matcher) {
        return new SuccessfullyCompletedFuture<T>(matcher);
    }

    public static <T> Matcher<Future<T>> futureWillCompleteWithException() {
        return FutureMatchers.futureWillCompleteWithExceptionThat((Matcher<? extends Throwable>)CoreMatchers.any(Throwable.class));
    }

    public static <T> Matcher<Future<T>> futureWillCompleteWithExceptionThat(Matcher<? extends Throwable> matcher) {
        return new ExceptionallyCompletedBlockingFuture(matcher);
    }

    public static Matcher<Future<?>> futureWillCompleteWithValue() {
        return FutureMatchers.futureWillCompleteWithValueThat(CoreMatchers.anything());
    }

    public static <T> Matcher<Future<? extends T>> futureWillCompleteWithValueThat(Matcher<T> matcher) {
        return new SuccessfullyCompletedBlockingFuture<T>(matcher);
    }
}

