/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.future;

import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class ExceptionallyCompletedFuture<T>
extends TypeSafeDiagnosingMatcher<Future<T>> {
    private final Matcher<? extends Throwable> matcher;

    ExceptionallyCompletedFuture(Matcher<? extends Throwable> matcher) {
        this.matcher = Objects.requireNonNull(matcher);
    }

    protected boolean matchesSafely(Future<T> future, Description mismatchDescription) {
        if (future.isDone()) {
            T value;
            if (future.isCancelled()) {
                mismatchDescription.appendText("a future that was cancelled");
                return false;
            }
            try {
                value = future.get();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (this.matcher.matches((Object)cause)) {
                    return true;
                }
                mismatchDescription.appendText("a future completed exceptionally with ");
                this.matcher.describeMismatch((Object)cause, mismatchDescription);
                return false;
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)"This should never happen because the future is completed.");
            }
            mismatchDescription.appendText("a future that completed to a value that was ").appendValue(value);
            return false;
        }
        mismatchDescription.appendText("a future that was not done");
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("a future that completed with an exception that ").appendDescriptionOf(this.matcher);
    }
}

