/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.future;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class ExceptionallyCompletedCompletionStage
extends TypeSafeDiagnosingMatcher<CompletionStage<?>> {
    private final Matcher<? extends Throwable> matcher;

    ExceptionallyCompletedCompletionStage(Matcher<? extends Throwable> matcher) {
        this.matcher = Objects.requireNonNull(matcher);
    }

    protected boolean matchesSafely(CompletionStage<?> stage, Description mismatchDescription) {
        CompletableFuture<?> future = stage.toCompletableFuture();
        if (future.isDone()) {
            if (future.isCancelled()) {
                mismatchDescription.appendText("a stage that was cancelled");
                return false;
            }
            if (future.isCompletedExceptionally()) {
                try {
                    future.getNow(null);
                    throw new AssertionError((Object)"This should never happen because the stage completed exceptionally.");
                }
                catch (CompletionException e) {
                    if (this.matcher.matches((Object)e.getCause())) {
                        return true;
                    }
                    mismatchDescription.appendText("a stage completed exceptionally with ");
                    this.matcher.describeMismatch((Object)e.getCause(), mismatchDescription);
                    return false;
                }
            }
            mismatchDescription.appendText("a stage that completed to a value that was ").appendValue(future.getNow(null));
            return false;
        }
        mismatchDescription.appendText("a stage that was not completed");
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("a stage that completed with an exception that ").appendDescriptionOf(this.matcher);
    }
}

