/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.future;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class ExceptionallyCompletedBlockingFuture<T>
extends TypeSafeDiagnosingMatcher<Future<T>> {
    private final Matcher<? extends Throwable> matcher;

    ExceptionallyCompletedBlockingFuture(Matcher<? extends Throwable> matcher) {
        this.matcher = Objects.requireNonNull(matcher);
    }

    protected boolean matchesSafely(Future<T> future, Description mismatchDescription) {
        try {
            T item = future.get();
            mismatchDescription.appendText("a future that completed to a value that was ").appendValue(item);
            return false;
        }
        catch (InterruptedException e) {
            mismatchDescription.appendText("a future that was interrupted");
            return false;
        }
        catch (CancellationException e) {
            mismatchDescription.appendText("a future that was cancelled");
            return false;
        }
        catch (ExecutionException e) {
            if (this.matcher.matches((Object)e.getCause())) {
                return true;
            }
            mismatchDescription.appendText("a future completed exceptionally with ");
            this.matcher.describeMismatch((Object)e.getCause(), mismatchDescription);
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText("a future that completed with an exception that ").appendDescriptionOf(this.matcher);
    }
}

