/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.future;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class ExceptionallyCompletedBlockingCompletionStage
extends TypeSafeDiagnosingMatcher<CompletionStage<?>> {
    private final Matcher<? extends Throwable> matcher;

    ExceptionallyCompletedBlockingCompletionStage(Matcher<? extends Throwable> matcher) {
        this.matcher = Objects.requireNonNull(matcher);
    }

    protected boolean matchesSafely(CompletionStage<?> stage, Description mismatchDescription) {
        try {
            Object item = stage.toCompletableFuture().get();
            mismatchDescription.appendText("a stage that completed with a value that was ").appendValue(item);
            return false;
        }
        catch (InterruptedException e) {
            mismatchDescription.appendText("a stage that was interrupted");
            return false;
        }
        catch (CancellationException e) {
            mismatchDescription.appendText("a stage that was cancelled");
            return false;
        }
        catch (ExecutionException e) {
            if (this.matcher.matches((Object)e.getCause())) {
                return true;
            }
            mismatchDescription.appendText("a stage completed exceptionally with ");
            this.matcher.describeMismatch((Object)e.getCause(), mismatchDescription);
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText("a stage completing with an exception that ").appendDescriptionOf(this.matcher);
    }
}

