/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.solcache;

import com.solacesystems.common.util.DestinationUtil;
import com.solacesystems.jcsmp.CacheLiveDataAction;
import com.solacesystems.jcsmp.CacheRequestListener;
import com.solacesystems.jcsmp.CacheSession;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageConsumer;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageProducer;
import com.solacesystems.jcsmp.impl.flow.LiveMessageController;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;

public class CacheRequestProperties {
    private CacheSession mSession;
    private JCSMPXMLMessageProducer mProducer;
    private JCSMPXMLMessageConsumer mConsumer;
    private LiveMessageController mLiveMsgCtrlr;
    private Long mRequestId;
    private Topic mTopic;
    private boolean mSubscribe;
    private CacheLiveDataAction mLiveDataAction;
    private CacheRequestListener mListener;
    private ArrayBlockingQueue<Object> mSyncQ;
    private ExecutorService mExecutor;
    private Long mMinSeqNum;
    private Long mMaxSeqNum;

    public CacheRequestProperties(CacheSession session, JCSMPXMLMessageProducer producer, JCSMPXMLMessageConsumer consumer, Long requestId, Topic topic, boolean subscribe, CacheLiveDataAction liveDataAction, ExecutorService executor) {
        if (topic == null) {
            throw new IllegalArgumentException("Topic cannot be null");
        }
        if (liveDataAction == null) {
            throw new IllegalArgumentException("CacheLiveDataAction cannot be null");
        }
        if (DestinationUtil.isWildCardedTrb(topic.getName()) && !liveDataAction.equals((Object)CacheLiveDataAction.FLOW_THRU)) {
            throw new IllegalArgumentException("Wildcard topic and live data action " + liveDataAction.toString() + " not supported");
        }
        this.mSession = session;
        this.mProducer = producer;
        this.mConsumer = consumer;
        this.mLiveMsgCtrlr = this.mConsumer.getLiveMessageController();
        this.mRequestId = requestId;
        this.mTopic = topic;
        this.mSubscribe = subscribe;
        this.mLiveDataAction = liveDataAction;
        this.mExecutor = executor;
        this.mListener = null;
        this.mSyncQ = new ArrayBlockingQueue(1);
        this.mMinSeqNum = null;
        this.mMaxSeqNum = null;
    }

    public CacheRequestProperties(CacheSession session, JCSMPXMLMessageProducer producer, JCSMPXMLMessageConsumer consumer, Long requestId, Topic topic, boolean subscribe, CacheLiveDataAction liveDataAction, ExecutorService executor, CacheRequestListener listener) {
        if (topic == null) {
            throw new IllegalArgumentException("Topic cannot be null");
        }
        if (liveDataAction == null) {
            throw new IllegalArgumentException("CacheLiveDataAction cannot be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("CacheRequestListener cannot be null");
        }
        if (DestinationUtil.isWildCardedTrb(topic.getName()) && !liveDataAction.equals((Object)CacheLiveDataAction.FLOW_THRU)) {
            throw new IllegalArgumentException("Wildcard topic and live data action " + liveDataAction.toString() + " not supported");
        }
        this.mSession = session;
        this.mProducer = producer;
        this.mConsumer = consumer;
        this.mLiveMsgCtrlr = this.mConsumer.getLiveMessageController();
        this.mRequestId = requestId;
        this.mTopic = topic;
        this.mSubscribe = subscribe;
        this.mLiveDataAction = liveDataAction;
        this.mExecutor = executor;
        this.mListener = listener;
        this.mSyncQ = null;
        this.mMinSeqNum = null;
        this.mMaxSeqNum = null;
    }

    public CacheRequestProperties(CacheSession session, JCSMPXMLMessageProducer producer, JCSMPXMLMessageConsumer consumer, Long requestId, Topic topic, boolean subscribe, CacheLiveDataAction liveDataAction, ExecutorService executor, long min, long max) {
        if (topic == null) {
            throw new IllegalArgumentException("Topic cannot be null");
        }
        if (liveDataAction == null) {
            throw new IllegalArgumentException("CacheLiveDataAction cannot be null");
        }
        if (DestinationUtil.isWildCardedTrb(topic.getName()) && !liveDataAction.equals((Object)CacheLiveDataAction.FLOW_THRU)) {
            throw new IllegalArgumentException("Wildcard topic and live data action " + liveDataAction.toString() + " not supported");
        }
        this.mSession = session;
        this.mProducer = producer;
        this.mConsumer = consumer;
        this.mLiveMsgCtrlr = this.mConsumer.getLiveMessageController();
        this.mRequestId = requestId;
        this.mTopic = topic;
        this.mSubscribe = subscribe;
        this.mLiveDataAction = liveDataAction;
        this.mExecutor = executor;
        this.mListener = null;
        this.mSyncQ = new ArrayBlockingQueue(1);
        this.mMinSeqNum = min;
        this.mMaxSeqNum = max;
    }

    public CacheRequestProperties(CacheSession session, JCSMPXMLMessageProducer producer, JCSMPXMLMessageConsumer consumer, Long requestId, Topic topic, boolean subscribe, CacheLiveDataAction liveDataAction, ExecutorService executor, CacheRequestListener listener, long min, long max) {
        if (topic == null) {
            throw new IllegalArgumentException("Topic cannot be null");
        }
        if (liveDataAction == null) {
            throw new IllegalArgumentException("CacheLiveDataAction cannot be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("CacheRequestListener cannot be null");
        }
        if (DestinationUtil.isWildCardedTrb(topic.getName()) && !liveDataAction.equals((Object)CacheLiveDataAction.FLOW_THRU)) {
            throw new IllegalArgumentException("Wildcard topic and live data action " + liveDataAction.toString() + " not supported");
        }
        this.mSession = session;
        this.mProducer = producer;
        this.mConsumer = consumer;
        this.mLiveMsgCtrlr = this.mConsumer.getLiveMessageController();
        this.mRequestId = requestId;
        this.mTopic = topic;
        this.mSubscribe = subscribe;
        this.mLiveDataAction = liveDataAction;
        this.mExecutor = executor;
        this.mListener = listener;
        this.mSyncQ = null;
        this.mMinSeqNum = min;
        this.mMaxSeqNum = max;
    }

    public CacheSession getSession() {
        return this.mSession;
    }

    public JCSMPXMLMessageProducer getProducer() {
        return this.mProducer;
    }

    public JCSMPXMLMessageConsumer getConsumer() {
        return this.mConsumer;
    }

    public LiveMessageController getLiveMessageController() {
        return this.mLiveMsgCtrlr;
    }

    public Long getRequestId() {
        return this.mRequestId;
    }

    public Topic getTopic() {
        return this.mTopic;
    }

    public boolean doSubscribe() {
        return this.mSubscribe;
    }

    public CacheLiveDataAction getLiveDataAction() {
        return this.mLiveDataAction;
    }

    public CacheRequestListener getListener() {
        return this.mListener;
    }

    public ArrayBlockingQueue<Object> getQueue() {
        return this.mSyncQ;
    }

    public boolean isBlocking() {
        return this.mListener == null;
    }

    public ExecutorService getExecutor() {
        return this.mExecutor;
    }

    public Long getMinSeqNum() {
        return this.mMinSeqNum;
    }

    public Long getMaxSeqNum() {
        return this.mMaxSeqNum;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append(this.mSession);
        bldr.append(", topic=");
        bldr.append(this.mTopic);
        bldr.append(", subscribe=");
        bldr.append(this.mSubscribe);
        bldr.append(", liveDataAction=");
        bldr.append((Object)this.mLiveDataAction);
        bldr.append(", blocking=");
        bldr.append(this.mListener == null);
        return bldr.toString();
    }
}

