/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.impl.SubscriptionMatchEntry;
import com.solacesystems.jcsmp.impl.SubscriptionRemoveResult;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class SubscriptionTree<T> {
    private static final byte STAR = 42;
    private static final byte SLASH = 47;
    private static final byte GREATER_THAN = 62;
    private static final byte[] WILDCARD = new byte[]{62};
    private SubscriptionTreeNode mRoot;

    public SubscriptionTree() {
        this.clear();
    }

    public SubscriptionTree(SubscriptionTree<T> tree) {
        this.mRoot = new SubscriptionTreeNode(tree.mRoot);
    }

    public void get(byte[] data, List<SubscriptionMatchEntry<T>> entries) {
        this.get(data, 0, data.length, entries);
    }

    public void get(byte[] data, int offset, int length, List<SubscriptionMatchEntry<T>> entries) {
        if (this.mRoot.mEntries != null && this.mRoot.mEntries.size() > 0) {
            entries.add(new SubscriptionMatchEntry(this.mRoot.mSubscription, this.mRoot.mEntries));
        }
        this.mRoot.get(data, entries);
    }

    public void put(byte[] subscription, T entry) {
        if (subscription.length == 1 && subscription[0] == 62) {
            this.mRoot.addEntry(entry);
        } else {
            this.mRoot.put(subscription, 0, subscription.length, entry);
        }
    }

    public void remove(byte[] subscription, T entry, SubscriptionRemoveResult result) {
        if (subscription.length == 1 && subscription[0] == 62) {
            this.mRoot.removeEntry(entry, result);
        } else {
            this.mRoot.remove(subscription, entry, result);
        }
    }

    public void clear() {
        this.mRoot = new SubscriptionTreeNode();
        SubscriptionTreeNode.access$102(this.mRoot, WILDCARD);
        this.mRoot.mIsRoot = true;
    }

    public int numNodes() {
        return this.mRoot.numNodes();
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        this.mRoot.toString(bldr, 0, false);
        return bldr.toString();
    }

    private class SubscriptionTreeNode {
        private byte[] mData;
        private int mLength;
        private HashMap<Byte, SubscriptionTreeNode> mTextChildren;
        private SubscriptionTreeNode mTextWildNode;
        private HashMap<Byte, SubscriptionTreeNode> mLevelChildren;
        private SubscriptionTreeNode mLevelWildNode;
        private SubscriptionTreeNode mLevelStarNode;
        private byte[] mSubscription;
        private List<T> mEntries;
        private boolean mIsRoot;
        private boolean mIsLast;

        public SubscriptionTreeNode() {
            this.mData = new byte[0];
            this.mLength = 0;
            this.mTextChildren = null;
            this.mTextWildNode = null;
            this.mLevelChildren = null;
            this.mLevelWildNode = null;
            this.mLevelStarNode = null;
            this.mSubscription = null;
            this.mEntries = null;
            this.mIsRoot = false;
            this.mIsLast = false;
        }

        public SubscriptionTreeNode(SubscriptionTreeNode node) {
            SubscriptionTreeNode value;
            this.mData = node.mData;
            this.mLength = node.mLength;
            if (node.mTextChildren == null) {
                this.mTextChildren = null;
            } else {
                this.mTextChildren = new HashMap();
                for (Byte key : node.mTextChildren.keySet()) {
                    value = node.mTextChildren.get(key);
                    this.mTextChildren.put(key, new SubscriptionTreeNode(value));
                }
            }
            this.mTextWildNode = node.mTextWildNode == null ? null : new SubscriptionTreeNode(node.mTextWildNode);
            if (node.mLevelChildren == null) {
                this.mLevelChildren = null;
            } else {
                this.mLevelChildren = new HashMap();
                for (Byte key : node.mLevelChildren.keySet()) {
                    value = node.mLevelChildren.get(key);
                    this.mLevelChildren.put(key, new SubscriptionTreeNode(value));
                }
            }
            this.mLevelWildNode = node.mLevelWildNode == null ? null : new SubscriptionTreeNode(node.mLevelWildNode);
            this.mLevelStarNode = node.mLevelStarNode == null ? null : new SubscriptionTreeNode(node.mLevelStarNode);
            this.mSubscription = node.mSubscription;
            if (node.mEntries == null) {
                this.mEntries = null;
            } else {
                this.mEntries = new ArrayList();
                for (int i = 0; i < node.mEntries.size(); ++i) {
                    this.mEntries.add(node.mEntries.get(i));
                }
            }
            this.mIsRoot = node.mIsRoot;
            this.mIsLast = node.mIsLast;
        }

        private SubscriptionTreeNode(byte[] subscription, int offset, int length, T entry) {
            this.mData = null;
            this.mLength = 0;
            this.mTextChildren = null;
            this.mTextWildNode = null;
            this.mLevelChildren = null;
            this.mLevelWildNode = null;
            this.mLevelStarNode = null;
            this.mSubscription = null;
            this.mEntries = null;
            this.mIsRoot = false;
            this.mIsLast = length < 2;
            for (int i = 0; i < length; ++i) {
                int index = offset + i;
                if (subscription[index] == 42) {
                    if (i == 0) continue;
                    if (i == length - 1) {
                        this.setData(subscription, offset, i);
                        this.addTextChild(new SubscriptionTreeNode(subscription, index, 1, entry));
                        return;
                    }
                    this.setData(subscription, offset, i);
                    this.addTextChild(new SubscriptionTreeNode(subscription, index, length - i, entry));
                    return;
                }
                if (subscription[index] != 47) continue;
                this.setData(subscription, offset, i);
                this.addLevelChild(new SubscriptionTreeNode(subscription, index + 1, length - (i + 1), entry));
                return;
            }
            this.setData(subscription, offset, length);
            this.mSubscription = subscription;
            this.addEntry(entry);
        }

        public void addEntryCheckDup(List<SubscriptionMatchEntry<T>> list, byte[] subscription, List<T> entries) {
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get(i).getMatch().equals(subscription) || !list.get(i).getEntries().equals(entries)) continue;
                return;
            }
            list.add(new SubscriptionMatchEntry(subscription, entries));
        }

        public void get(byte[] data, List<SubscriptionMatchEntry<T>> entries) {
            this.get(data, 0, data.length, entries);
        }

        public void get(byte[] data, int offset, int length, List<SubscriptionMatchEntry<T>> entries) {
            if (this.mLength == 1 && this.mData[0] == 42) {
                int index;
                int end = offset + length;
                for (index = offset; index < end && data[index] != 47; ++index) {
                }
                if (index < end) {
                    this.getToChildren(data, index, length - (index - offset), entries);
                } else if (this.isTerminal()) {
                    this.addEntryCheckDup(entries, this.mSubscription, this.mEntries);
                }
            } else {
                if (length < this.mLength) {
                    return;
                }
                for (int i = 1; i < this.mLength; ++i) {
                    if (this.mData[i] == data[offset + i]) continue;
                    return;
                }
                if (this.mLength == length) {
                    if (this.isTerminal()) {
                        this.addEntryCheckDup(entries, this.mSubscription, this.mEntries);
                    }
                    if (this.mTextWildNode != null && this.mTextWildNode.isTerminal()) {
                        this.addEntryCheckDup(entries, this.mTextWildNode.mSubscription, this.mTextWildNode.mEntries);
                    }
                    return;
                }
                this.getToChildren(data, offset + this.mLength, length - this.mLength, entries);
            }
        }

        public void put(byte[] subscription, int offset, int length, T entry) {
            for (int i = 1; i < this.mLength; ++i) {
                if (i == length) {
                    this.addTextChild(i, subscription, offset, length, entry);
                    return;
                }
                if (subscription[offset + i] == 47) {
                    this.addLevelChild(i, subscription, offset, length, entry);
                    return;
                }
                if (this.mData[i] == subscription[offset + i]) continue;
                this.addTextChild(i, subscription, offset, length, entry);
                return;
            }
            int index = offset + this.mLength;
            if (index >= subscription.length) {
                this.mSubscription = subscription;
                this.addEntry(entry);
            } else if (subscription[index] == 47) {
                SubscriptionTreeNode child = this.getLevelChild(subscription[index + 1], index == subscription.length - 2);
                if (child == null) {
                    this.addLevelChild(new SubscriptionTreeNode(subscription, index + 1, length - this.mLength - 1, entry));
                } else {
                    child.put(subscription, index + 1, length - this.mLength - 1, entry);
                }
            } else {
                SubscriptionTreeNode child = this.getTextChild(subscription[index]);
                if (child == null) {
                    this.addTextChild(new SubscriptionTreeNode(subscription, index, length - this.mLength, entry));
                } else {
                    child.put(subscription, index, length - this.mLength, entry);
                }
            }
        }

        public void remove(byte[] subscription, T entry, SubscriptionRemoveResult result) {
            this.remove(subscription, 0, subscription.length, entry, result);
        }

        public void remove(byte[] subscription, int offset, int length, T entry, SubscriptionRemoveResult result) {
            for (int i = 0; i < this.mLength; ++i) {
                if (i >= length) {
                    return;
                }
                if (this.mData[i] == subscription[offset + i]) continue;
                return;
            }
            if (this.mLength == length) {
                this.removeEntry(entry, result);
            } else {
                int next = offset + this.mLength;
                if (subscription[next] == 47) {
                    SubscriptionTreeNode child;
                    if ((child = this.getLevelChild(subscription[++next], next == subscription.length - 1)) == null) {
                        return;
                    }
                    child.remove(subscription, next, length - (next - offset), entry, result);
                    if (result.isFound() && result.numEntriesFound() == 1 && child.isDisposable()) {
                        this.removeLevelChild(subscription[next], next == subscription.length - 1);
                        this.merge();
                    }
                } else {
                    SubscriptionTreeNode child = this.getTextChild(subscription[next]);
                    if (child == null) {
                        return;
                    }
                    child.remove(subscription, next, length - (next - offset), entry, result);
                    if (result.isFound() && result.numEntriesFound() == 1 && child.isDisposable()) {
                        this.removeTextChild(subscription[next]);
                        this.merge();
                    }
                }
            }
        }

        private byte getKey() {
            return this.mData[0];
        }

        private SubscriptionTreeNode getTextChild(byte b) {
            if (b == 42) {
                return this.mTextWildNode;
            }
            if (this.mTextChildren == null) {
                return null;
            }
            return this.mTextChildren.get(b);
        }

        private void removeTextChild(byte b) {
            if (b == 42) {
                this.mTextWildNode = null;
            } else if (this.mTextChildren != null) {
                this.mTextChildren.remove(b);
            }
        }

        private SubscriptionTreeNode getLevelChild(byte b, boolean isLast) {
            if (b == 62 && isLast) {
                return this.mLevelWildNode;
            }
            if (b == 42) {
                return this.mLevelStarNode;
            }
            if (this.mLevelChildren == null) {
                return null;
            }
            return this.mLevelChildren.get(b);
        }

        private void removeLevelChild(byte b, boolean isLast) {
            if (b == 62 && isLast) {
                this.mLevelWildNode = null;
            } else if (b == 42) {
                this.mLevelStarNode = null;
            } else if (this.mLevelChildren != null) {
                this.mLevelChildren.remove(b);
            }
        }

        public int numNodes() {
            SubscriptionTreeNode child;
            Iterator<Byte> it;
            int num = 1;
            if (this.mLevelWildNode != null) {
                num += this.mLevelWildNode.numNodes();
            }
            if (this.mLevelStarNode != null) {
                num += this.mLevelStarNode.numNodes();
            }
            if (this.mLevelChildren != null) {
                it = this.mLevelChildren.keySet().iterator();
                while (it.hasNext()) {
                    child = this.mLevelChildren.get(it.next());
                    num += child.numNodes();
                }
            }
            if (this.mTextWildNode != null) {
                num += this.mTextWildNode.numNodes();
            }
            if (this.mTextChildren != null) {
                it = this.mTextChildren.keySet().iterator();
                while (it.hasNext()) {
                    child = this.mTextChildren.get(it.next());
                    num += child.numNodes();
                }
            }
            return num;
        }

        public boolean hasChildren() {
            if (this.mLevelWildNode != null || this.mLevelStarNode != null || this.mTextWildNode != null) {
                return true;
            }
            if (this.mLevelChildren != null && this.mLevelChildren.size() > 0) {
                return true;
            }
            return this.mTextChildren != null && this.mTextChildren.size() > 0;
        }

        public boolean isTerminal() {
            return this.mEntries != null && this.mEntries.size() > 0;
        }

        public boolean isDisposable() {
            return !this.isTerminal() && !this.hasChildren();
        }

        private void getToChildren(byte[] data, int index, int length, List<SubscriptionMatchEntry<T>> entries) {
            if (data[index] == 47) {
                SubscriptionTreeNode child;
                if (this.mLevelWildNode != null) {
                    this.addEntryCheckDup(entries, this.mLevelWildNode.mSubscription, this.mLevelWildNode.mEntries);
                }
                if (this.mLevelStarNode != null) {
                    this.mLevelStarNode.get(data, index + 1, length - 1, entries);
                }
                if (this.mTextWildNode != null) {
                    this.mTextWildNode.getToChildren(data, index, length, entries);
                }
                if ((child = this.getLevelChild(data[index + 1], false)) != null) {
                    child.get(data, index + 1, length - 1, entries);
                }
            } else {
                SubscriptionTreeNode child;
                if (this.mTextWildNode != null) {
                    this.mTextWildNode.get(data, index, length, entries);
                }
                if ((child = this.getTextChild(data[index])) == null) {
                    return;
                }
                child.get(data, index, length, entries);
            }
        }

        private void addTextChild(SubscriptionTreeNode node) {
            if (node.getKey() == 42) {
                this.mTextWildNode = node;
            } else {
                if (this.mTextChildren == null) {
                    this.mTextChildren = new HashMap();
                }
                this.mTextChildren.put(node.getKey(), node);
            }
        }

        private void addTextChild(int index, byte[] subscription, int offset, int length, T entry) {
            this.split(index);
            if (index < length) {
                this.addTextChild(new SubscriptionTreeNode(subscription, offset + index, length - index, entry));
            } else {
                this.mSubscription = subscription;
                this.addEntry(entry);
            }
        }

        private void addLevelChild(SubscriptionTreeNode node) {
            if (node.getKey() == 62 && node.mIsLast) {
                this.mLevelWildNode = node;
            } else if (node.getKey() == 42) {
                this.mLevelStarNode = node;
            } else {
                if (this.mLevelChildren == null) {
                    this.mLevelChildren = new HashMap();
                }
                this.mLevelChildren.put(node.getKey(), node);
            }
        }

        private void addLevelChild(int index, byte[] subscription, int offset, int length, T entry) {
            this.split(index);
            this.addLevelChild(new SubscriptionTreeNode(subscription, offset + index + 1, length - this.mLength - 1, entry));
        }

        private void setData(byte[] data, int offset, int length) {
            this.mData = new byte[length];
            for (int i = 0; i < length; ++i) {
                this.mData[i] = data[offset + i];
            }
            this.mLength = length;
        }

        private void addEntry(T entry) {
            if (entry != null) {
                if (this.mEntries == null) {
                    this.mEntries = new ArrayList();
                }
                this.mEntries.add(entry);
            }
        }

        private void removeEntry(T entry, SubscriptionRemoveResult result) {
            if (entry != null && this.mEntries != null) {
                result.setNumEntriesFound(this.mEntries.size());
                for (int i = 0; i < this.mEntries.size(); ++i) {
                    if (!this.mEntries.get(i).equals(entry)) continue;
                    result.setFound();
                    this.mEntries.remove(i);
                    if (this.mEntries.size() == 0) {
                        this.mEntries = null;
                    }
                    return;
                }
            }
        }

        private void split(int index) {
            SubscriptionTreeNode child;
            byte[] newData = new byte[index];
            for (int j = 0; j < index; ++j) {
                newData[j] = this.mData[j];
            }
            SubscriptionTreeNode newNode = new SubscriptionTreeNode(this.mData, index, this.mLength - index, null);
            newNode.mSubscription = this.mSubscription;
            this.mData = newData;
            this.mLength = index;
            this.mSubscription = null;
            if (this.mEntries != null) {
                for (int i = 0; i < this.mEntries.size(); ++i) {
                    newNode.addEntry(this.mEntries.get(i));
                }
                this.mEntries.clear();
            }
            newNode.mLevelWildNode = this.mLevelWildNode;
            this.mLevelWildNode = null;
            newNode.mLevelStarNode = this.mLevelStarNode;
            this.mLevelStarNode = null;
            if (this.mLevelChildren != null) {
                Iterator<Byte> it = this.mLevelChildren.keySet().iterator();
                while (it.hasNext()) {
                    child = this.mLevelChildren.get(it.next());
                    it.remove();
                    newNode.addLevelChild(child);
                }
            }
            newNode.mTextWildNode = this.mTextWildNode;
            this.mTextWildNode = null;
            if (this.mTextChildren != null) {
                Iterator<Byte> it = this.mTextChildren.keySet().iterator();
                while (it.hasNext()) {
                    child = this.mTextChildren.get(it.next());
                    it.remove();
                    newNode.addTextChild(child);
                }
            }
            this.addTextChild(newNode);
        }

        private void merge() {
            int i;
            if (this.mLevelWildNode != null || this.mLevelStarNode != null || this.mTextWildNode != null) {
                return;
            }
            if (this.mLevelChildren != null && this.mLevelChildren.size() > 0) {
                return;
            }
            if (this.mTextChildren == null || this.mTextChildren.size() != 1) {
                return;
            }
            if (this.isTerminal()) {
                return;
            }
            if (this.mIsRoot) {
                return;
            }
            Iterator<Byte> it = this.mTextChildren.keySet().iterator();
            byte key = it.next();
            SubscriptionTreeNode child = this.mTextChildren.get(key);
            byte[] newData = new byte[this.mLength + child.mLength];
            for (i = 0; i < this.mLength; ++i) {
                newData[i] = this.mData[i];
            }
            for (i = 0; i < child.mLength; ++i) {
                newData[i + this.mLength] = child.mData[i];
            }
            this.mData = newData;
            this.mLength += child.mLength;
            this.mTextChildren = child.mTextChildren;
            this.mTextWildNode = child.mTextWildNode;
            this.mLevelChildren = child.mLevelChildren;
            this.mLevelWildNode = child.mLevelWildNode;
            this.mLevelStarNode = child.mLevelStarNode;
            this.mSubscription = child.mSubscription;
            this.mEntries = child.mEntries;
        }

        public String toString() {
            StringBuilder bldr = new StringBuilder();
            this.toString(bldr, 0, false);
            return bldr.toString();
        }

        public void toString(StringBuilder bldr, int leadingSpaces, boolean leadingSlash) {
            SubscriptionTreeNode child;
            for (int i = 0; i < leadingSpaces; ++i) {
                bldr.append(" ");
            }
            if (this.isTerminal()) {
                if (leadingSlash) {
                    bldr.append("[/");
                } else {
                    bldr.append("[");
                }
            } else if (leadingSlash) {
                bldr.append("(/");
            } else {
                bldr.append("(");
            }
            bldr.append(new String(this.mData, Charset.forName("UTF-8")));
            if (this.isTerminal()) {
                bldr.append("]");
                if (this.mEntries.size() > 1) {
                    bldr.append('(');
                    bldr.append(this.mEntries.size());
                    bldr.append(')');
                }
                bldr.append("\r\n");
            } else {
                bldr.append(")\r\n");
            }
            if (this.mTextChildren != null) {
                Iterator<Byte> it = this.mTextChildren.keySet().iterator();
                while (it.hasNext()) {
                    child = this.mTextChildren.get(it.next());
                    child.toString(bldr, leadingSpaces + this.mLength + 2, false);
                }
            }
            if (this.mTextWildNode != null) {
                this.mTextWildNode.toString(bldr, leadingSpaces + this.mLength + 2, false);
            }
            if (this.mLevelChildren != null) {
                Iterator<Byte> it = this.mLevelChildren.keySet().iterator();
                while (it.hasNext()) {
                    child = this.mLevelChildren.get(it.next());
                    child.toString(bldr, leadingSpaces + this.mLength + 2, true);
                }
            }
            if (this.mLevelWildNode != null) {
                this.mLevelWildNode.toString(bldr, leadingSpaces + this.mLength + 2, true);
            }
            if (this.mLevelStarNode != null) {
                this.mLevelStarNode.toString(bldr, leadingSpaces + this.mLength + 2, true);
            }
        }

        static /* synthetic */ byte[] access$102(SubscriptionTreeNode x0, byte[] x1) {
            x0.mSubscription = x1;
            return x1;
        }
    }
}

