/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util.i18n;

import com.solacesystems.common.ChainedException;
import com.solacesystems.common.util.trace.Trace;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class GenericResourceBundleSupport {
    protected ResourceBundle m_bundle;
    protected ClassLoader m_classLoader;
    protected String m_baseName;
    public static final String LOCAL_LANGUAGE_CMDARG = "Bundle.Locale.language";
    public static final String LOCAL_COUNTRY_CMDARG = "Bundle.Locale.country";

    public GenericResourceBundleSupport(String baseName, ClassLoader classloader) throws MissingResourceException {
        this.m_classLoader = classloader;
        this.initialize(baseName, classloader, this.getSpecifiedLocale());
    }

    private void initialize(String basename, ClassLoader classloader, Locale locale) {
        block2: {
            this.m_baseName = basename;
            try {
                this.m_bundle = ResourceBundle.getBundle(basename, locale, classloader);
            }
            catch (MissingResourceException exception) {
                String message = "-----Missing resource bundle-----\n Ensure that the bundle exists in a directory, .jar or .zip in the class path.\n Base Name: " + this.m_baseName;
                if (!Trace.isErrorEnabled(this)) break block2;
                Trace.error((Object)this, message);
            }
        }
    }

    private Locale getSpecifiedLocale() {
        Locale locale = Locale.US;
        try {
            String country = System.getProperty(LOCAL_COUNTRY_CMDARG);
            String language = System.getProperty(LOCAL_LANGUAGE_CMDARG);
            if (country != null && language != null) {
                locale = new Locale(language, country);
                return locale;
            }
            return locale;
        }
        catch (Exception e) {
            return locale;
        }
    }

    protected void handleAndRethrow(ClassCastException exception, String key, Object object, String type) throws ChainedException {
        String message = "-----Wrong resource type-----\n Correct the search key or change the value in the resource bundle: " + this.m_bundle.getClass().getName() + " with key: " + key + (object == null ? "\nObject: null" : "Object type: " + object.getClass());
        if (Trace.isErrorEnabled(this)) {
            Trace.error((Object)this, message);
        }
        throw new ChainedException(message, exception);
    }

    protected void handleAndRethrow(MissingResourceException exception, String key) throws ChainedException {
        String message = "-----Missing resource key-----\nCorrect the search key or add it to the specified bundle: " + this.m_bundle.getClass().getName() + "\nKey: " + key;
        if (Trace.isErrorEnabled(this)) {
            Trace.error((Object)this, message);
        }
        throw new ChainedException(message, exception);
    }

    protected void handleMissingFileAndRethrow(String key, String fileName) throws ChainedException {
        String message = "-----Missing file-----\nEnsure that the file exists in a directory,.jar or .zip in the class path. \n Bundle: " + this.m_bundle.getClass().getName() + "\nKey: " + key + "\nFile Name: " + fileName;
        if (Trace.isErrorEnabled(this)) {
            Trace.error((Object)this, message);
        }
        throw new ChainedException(message);
    }

    public Object getObject(String key) throws ChainedException {
        try {
            return this.m_bundle.getObject(key);
        }
        catch (MissingResourceException exception) {
            this.handleAndRethrow(exception, key);
            return "";
        }
    }
}

