/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.expect;

import com.solacesystems.common.expect.ConfigurationMatcher;
import com.solacesystems.common.expect.DefaultExceptionMatcher;
import com.solacesystems.common.expect.Expect;
import com.solacesystems.common.expect.ExpectDatabase;
import com.solacesystems.common.expect.Outcome;
import com.solacesystems.common.expect.UnexpectedException;

public class Example {
    private static final String IllegalArgument = "IllegalArgument";
    private static final ExpectDatabase ExpectDB = Example.PopulateExpectDB();

    private static ExpectDatabase PopulateExpectDB() {
        ExpectDatabase db = new ExpectDatabase(new String[]{"com.solacesystems.common.expect"});
        db.add(IllegalArgument, Outcome.Exception, new ConfigurationMatcher(){

            @Override
            public boolean configurationMatches(Object ctx) {
                return true;
            }
        }, new DefaultExceptionMatcher(IllegalArgumentException.class, DefaultExceptionMatcher.ClassMatch.SameClass, "gaga", DefaultExceptionMatcher.StringMatch.Exact));
        return db;
    }

    public void test1() {
        try {
            int i = 0;
            ++i;
            this.handleSuccess();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void test2() {
        try {
            throw new IllegalArgumentException("gaga");
        }
        catch (Exception e) {
            this.handleException(e);
            return;
        }
    }

    @Expect(value={"IllegalArgument"})
    public void test3() {
        try {
            throw new IllegalArgumentException("gaga");
        }
        catch (Exception e) {
            this.handleException(e);
            return;
        }
    }

    @Expect(value={"IllegalArgument"})
    public void test4() {
        try {
            this.handleSuccess();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void handleSuccess() {
        try {
            String expect = ExpectDB.handleSuccess(null);
            if (expect == null) {
                this.printOutcome("Pass", "No Conditions Matched");
            } else {
                this.printOutcome("Pass", "Condition Matched = \"" + expect + "\"");
            }
        }
        catch (UnexpectedException e) {
            this.printOutcome("Failed", e.getMessage());
        }
    }

    private void handleFailure() {
        try {
            String expect = ExpectDB.handleFailure(null);
            this.printOutcome("Pass", "a failure occurred but was expected by \"" + expect + "\"");
        }
        catch (UnexpectedException e) {
            this.printOutcome("Failed", e.getMessage());
        }
    }

    private void handleException(Exception e) {
        try {
            String expect = ExpectDB.handleException(null, e);
            this.printOutcome("Pass", "an exception was thrown but was expected by \"" + expect + "\"");
        }
        catch (UnexpectedException e1) {
            this.printOutcome("Failed", e1.getMessage());
        }
    }

    private void printOutcome(String testOutcome, String message) {
        Throwable t = new Throwable();
        t.fillInStackTrace();
        StackTraceElement[] elements = t.getStackTrace();
        String methodName = "";
        if (elements.length > 2) {
            methodName = elements[2].getMethodName();
        }
        System.out.println(methodName + "(" + testOutcome + ") - " + message);
    }

    public static void main(String[] args) {
        Example example = new Example();
        example.test1();
        example.test2();
        example.test3();
        example.test4();
    }
}

