/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.nio.impl;

import com.solacesystems.jcsmp.JCSMPSessionStats;
import com.solacesystems.jcsmp.protocol.nio.IOConstants;
import com.solacesystems.jcsmp.protocol.nio.ReadIOHandler;
import com.solacesystems.jcsmp.statistics.StatType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;

public abstract class AbstractSMFReadHandler
implements ReadIOHandler,
IOConstants {
    ByteBuffer _inputBuf = ByteBuffer.allocate(64000);
    final Object _inputBufLock = new Object();
    int _bytesLastDrain = 0;
    final JCSMPSessionStats _sessionStats;

    protected AbstractSMFReadHandler(JCSMPSessionStats stats) {
        this._sessionStats = stats;
    }

    protected void closeChannel() throws IOException {
        this.getChannel().close();
    }

    protected void drain() throws IOException {
        this.drainSocketData();
    }

    protected void drainSocketData() throws IOException {
        this._bytesLastDrain = 0;
        int cnt = 0;
        ByteChannel s = (ByteChannel)((Object)this.getChannel());
        cnt = s.read(this._inputBuf);
        this._bytesLastDrain += cnt;
        if (cnt < 0) {
            this.closeChannel();
        }
        this._sessionStats.incStat(StatType.TOTAL_SOCKET_BYTES_RECVED, this._bytesLastDrain);
    }

    protected void resizeBuffer(int finalSize) {
        ByteBuffer newBuffer = ByteBuffer.allocate(finalSize);
        assert (this._inputBuf.position() == 0);
        int existingDataLen = this._inputBuf.remaining();
        if (existingDataLen > finalSize) {
            throw new IllegalArgumentException("Specified a smaller destination buffer than source.");
        }
        newBuffer.put(this._inputBuf);
        this._inputBuf = newBuffer;
    }

    public static InputStream newByteBufferInputStream(final ByteBuffer sourceBuffer) {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                if (!sourceBuffer.hasRemaining()) {
                    return -1;
                }
                return sourceBuffer.get();
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                len = Math.min(len, sourceBuffer.remaining());
                sourceBuffer.get(bytes, off, len);
                return len;
            }
        };
    }

    abstract boolean isReadComplete() throws IOException;

    abstract void processRead() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBuffers() {
        Object object = this._inputBufLock;
        synchronized (object) {
            this._inputBuf.clear();
            if (this._inputBuf.limit() > 64000) {
                this._inputBuf = ByteBuffer.allocate(64000);
            }
        }
    }
}

