/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.util.internal;

import com.solace.messaging.Message;
import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.Validation;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.User_Cos;
import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.impl.sdt.MapImpl;
import java.lang.reflect.Field;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class SolaceMessageUtil {
    private static final Log logger = LogFactory.getLog(SolaceMessageUtil.class);

    private SolaceMessageUtil() {
    }

    public static void addPropertiesToMessage(XMLMessage message, TypedProperties.ConfigurationProperties configurationProperties) {
        Properties untyped;
        Set<Object> keys;
        Integer cosValueProp;
        Long sequenceNumber;
        String correlationId;
        String contentType;
        String contentEncoding;
        String appId;
        String appType;
        Boolean ackImmediately;
        Boolean dmqEligible;
        Long expiration;
        Long ttl;
        String senderId;
        Integer priority;
        Validation.nullIllegal(message, "'null' is an illegal message value.");
        Validation.nullIllegal(configurationProperties, "'null' is an illegal configurationProperties value.");
        TypedProperties typed = configurationProperties.getTypedProperties();
        Boolean elidingEligible = typed.getBooleanProperty("solace.messaging.message.eliding-eligible");
        if (null != elidingEligible) {
            message.setElidingEligible(elidingEligible.booleanValue());
        }
        if ((priority = typed.getIntegerProperty("solace.messaging.message.priority")) != null) {
            message.setPriority(priority.intValue());
        }
        if ((senderId = typed.getProperty("solace.messaging.message.sender-id")) != null) {
            message.setSenderId(senderId);
        }
        if ((ttl = typed.getLongProperty("solace.messaging.message.persistent.time-to-live")) != null) {
            message.setTimeToLive(ttl.longValue());
        }
        if ((expiration = typed.getLongProperty("solace.messaging.message.persistent.expiration")) != null) {
            message.setExpiration(expiration.longValue());
        }
        if ((dmqEligible = typed.getBooleanProperty("solace.messaging.message.persistent.dmq-eligible")) != null) {
            message.setDMQEligible(dmqEligible.booleanValue());
        }
        if ((ackImmediately = typed.getBooleanProperty("solace.messaging.message.persistent.ack-immediately")) != null) {
            message.setAckImmediately(ackImmediately.booleanValue());
        }
        if ((appType = typed.getProperty("solace.messaging.message.application-message-type")) != null) {
            message.setApplicationMessageType(appType);
        }
        if ((appId = typed.getProperty("solace.messaging.message.application-message-id")) != null) {
            message.setApplicationMessageId(appId);
        }
        if ((contentEncoding = typed.getProperty("solace.messaging.message.http-encoding")) != null) {
            message.setHTTPContentEncoding(contentEncoding);
        }
        if ((contentType = typed.getProperty("solace.messaging.message.http-content")) != null) {
            message.setHTTPContentType(contentType);
        }
        if ((correlationId = typed.getProperty("solace.messaging.message.correlation-id")) != null) {
            message.setCorrelationId(correlationId);
        }
        if ((sequenceNumber = typed.getLongProperty("solace.messaging.message.persistent.sequence-number")) != null) {
            message.setSequenceNumber(sequenceNumber.longValue());
        }
        if ((cosValueProp = typed.getIntegerProperty("solace.messaging.message.class-of-service")) != null) {
            int cosValue = cosValueProp;
            if (cosValue < 0 || cosValue > User_Cos.values().length - 1) {
                throw new IllegalArgumentException("Class Of Service value out of range [0:2]");
            }
            message.setCos(User_Cos.values()[cosValue]);
        }
        if (!(keys = (untyped = configurationProperties.getUntypedProperties()).keySet()).isEmpty()) {
            if (null == message.getProperties()) {
                message.setProperties((SDTMap)new MapImpl());
            }
            SDTMap customPropertiesHolder = message.getProperties();
            untyped.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                block6: {
                    try {
                        try {
                            if (k != null && v != null) {
                                customPropertiesHolder.putString(k.toString(), v.toString());
                            }
                        }
                        catch (Exception e) {
                            if (logger.isWarnEnabled()) {
                                logger.warn((Object)("Problem with adding custom property to a message, key=" + k + ", value=" + v), (Throwable)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isWarnEnabled()) break block6;
                        logger.warn((Object)"Problem with adding custom property to a message", (Throwable)e);
                    }
                }
            }));
            message.setProperties(customPropertiesHolder);
        }
    }

    public static BytesXMLMessage getSolaceMessage(Message message) {
        Validation.nullIllegal(message, "'null' is an illegal message value.");
        if (!(message instanceof Message.SolaceMessageImpl)) {
            throw new PubSubPlusClientException("Unsupported Message type");
        }
        Field solaceMessageField = null;
        try {
            Message.SolaceMessageImpl msgImpl = (Message.SolaceMessageImpl)message;
            solaceMessageField = Message.SolaceMessageImpl.class.getDeclaredField("solaceMessage");
            solaceMessageField.setAccessible(true);
            BytesXMLMessage bytesXMLMessage = (BytesXMLMessage)solaceMessageField.get(msgImpl);
            return bytesXMLMessage;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new PubSubPlusClientException("Failed to retrieve internal message", e);
        }
        finally {
            solaceMessageField.setAccessible(false);
        }
    }
}

