/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.util.internal;

import com.solace.messaging.MessagingService;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.MessagingServiceEventDispatcher;
import com.solace.messaging.util.internal.ServiceEventImpl;
import com.solacesystems.jcsmp.SessionEvent;
import com.solacesystems.jcsmp.SessionEventArgs;
import com.solacesystems.jcsmp.SessionEventHandler;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class SessionEventHandlerAdapter
implements SessionEventHandler,
MessagingServiceEventDispatcher {
    private static final Log logger = LogFactory.getLog(SessionEventHandlerAdapter.class);
    private final Map<MessagingService.ReconnectionListener, Boolean> reconnectionListenerMap = new ConcurrentHashMap<MessagingService.ReconnectionListener, Boolean>();
    private final Set<MessagingService.ReconnectionListener> reconnectionListenerView = this.reconnectionListenerMap.keySet();
    private final Map<MessagingService.ReconnectionAttemptListener, Boolean> reconnectionAttemptListenerMap = new ConcurrentHashMap<MessagingService.ReconnectionAttemptListener, Boolean>();
    private final Set<MessagingService.ReconnectionAttemptListener> reconnectionAttemptListenerView = this.reconnectionAttemptListenerMap.keySet();
    private final ConcurrentMap<MessagingService.ServiceInterruptionListener, Boolean> downListenerMap = new ConcurrentHashMap<MessagingService.ServiceInterruptionListener, Boolean>();
    private final Set<MessagingService.ServiceInterruptionListener> sessionDownListenersView = this.downListenerMap.keySet();
    private volatile JCSMPBasicSession session;

    void setJCSMPBasicSession(JCSMPBasicSession s) {
        this.session = s;
    }

    @Override
    public void removeAllListener() {
        this.sessionDownListenersView.clear();
        this.reconnectionListenerView.clear();
        this.reconnectionAttemptListenerView.clear();
    }

    @Override
    public void addReconnectionListener(MessagingService.ReconnectionListener l) {
        this.reconnectionListenerMap.put(l, Boolean.FALSE);
    }

    @Override
    public void addReconnectionListeners(Collection<MessagingService.ReconnectionListener> ls) {
        ls.forEach(l -> this.addReconnectionListener((MessagingService.ReconnectionListener)l));
    }

    @Override
    public boolean removeReconnectionListener(MessagingService.ReconnectionListener l) {
        return this.reconnectionListenerView.remove(l);
    }

    @Override
    public void addReconnectionAttemptListener(MessagingService.ReconnectionAttemptListener l) {
        this.reconnectionAttemptListenerMap.put(l, Boolean.FALSE);
    }

    @Override
    public void addReconnectionAttemptListeners(Collection<MessagingService.ReconnectionAttemptListener> ls) {
        ls.forEach(l -> this.addReconnectionAttemptListener((MessagingService.ReconnectionAttemptListener)l));
    }

    @Override
    public boolean removeReconnectionAttemptListener(MessagingService.ReconnectionAttemptListener l) {
        return this.reconnectionAttemptListenerView.remove(l);
    }

    @Override
    public void addServiceInterruptionListener(MessagingService.ServiceInterruptionListener l) {
        this.downListenerMap.put(l, Boolean.FALSE);
    }

    @Override
    public boolean removeServiceInterruptionListener(MessagingService.ServiceInterruptionListener l) {
        return this.sessionDownListenersView.remove(l);
    }

    void onReconnection(String uri, Exception e, String message) {
        this.reconnectionListenerView.forEach(l -> {
            block2: {
                try {
                    l.onReconnected(new ServiceEventImpl(uri, e, message));
                }
                catch (Exception ex) {
                    if (!logger.isWarnEnabled()) break block2;
                    logger.warn((Object)"Application code throw an unhandled exception by processing of reconnection event", (Throwable)ex);
                }
            }
        });
    }

    void onReconnecting(String uri, Exception e, String message) {
        this.reconnectionAttemptListenerView.forEach(l -> {
            block2: {
                try {
                    l.onReconnecting(new ServiceEventImpl(uri, e, message));
                }
                catch (Exception ex) {
                    if (!logger.isWarnEnabled()) break block2;
                    logger.warn((Object)"Application code throw an unhandled exception by processing of reconnecting event", (Throwable)ex);
                }
            }
        });
    }

    void onShutdownByError(String uri, Exception e, String message) {
        this.sessionDownListenersView.forEach(l -> {
            block2: {
                try {
                    l.onServiceInterrupted(new ServiceEventImpl(uri, e, message));
                }
                catch (Exception ex) {
                    if (!logger.isWarnEnabled()) break block2;
                    logger.warn((Object)"Application code throw an unhandled exception by processing of service interrupted event", (Throwable)ex);
                }
            }
        });
        this.removeAllListener();
    }

    public void handleEvent(SessionEventArgs sessionEventArgs) {
        SessionEvent event = sessionEventArgs.getEvent();
        if (SessionEvent.DOWN_ERROR == event || SessionEvent.RECONNECTING == event || SessionEvent.RECONNECTED == event) {
            JCSMPBasicSession s = this.session;
            String uri = "n/a";
            if (s != null && s.getClientChannel() != null && s.getClientChannel().getSmfClient() != null) {
                uri = s.getClientChannel().getSmfClient().getRemoteHost();
            }
            switch (event) {
                case DOWN_ERROR: {
                    this.onShutdownByError(uri, sessionEventArgs.getException(), sessionEventArgs.getInfo());
                    break;
                }
                case RECONNECTING: {
                    this.onReconnecting(uri, sessionEventArgs.getException(), sessionEventArgs.getInfo());
                    break;
                }
                case RECONNECTED: {
                    this.onReconnection(uri, sessionEventArgs.getException(), sessionEventArgs.getInfo());
                    break;
                }
            }
        }
    }
}

