/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.util.async;

import com.solace.messaging.util.internal.Internal;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class ExtendedCompletableFuture<T>
extends CompletableFuture<T> {
    public static <T> CompletableFuture<T> onCancellation(CompletableFuture<T> in, BiConsumer<? super T, ? super Throwable> cancellationAction) {
        return in.whenComplete((T service, U throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CancellationException) {
                    cancellationAction.accept((Object)service, (Throwable)throwable);
                } else if (throwable instanceof CompletionException && throwable.getCause() != null && throwable.getCause() instanceof CancellationException) {
                    cancellationAction.accept(service, throwable.getCause());
                }
            }
        });
    }

    public static <U> CompletableFuture<U> failedFuture(Throwable ex) {
        Objects.requireNonNull(ex);
        ExtendedCompletableFuture f = new ExtendedCompletableFuture();
        f.completeExceptionally(ex);
        return f;
    }

    public static <U, T extends CompletableFuture<U>> T failedFuture(Throwable ex, T cf) {
        Objects.requireNonNull(ex);
        cf.completeExceptionally(ex);
        return cf;
    }
}

