/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.publisher;

import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.publisher.MessagePublisher;
import com.solace.messaging.publisher.OutboundMessage;
import com.solace.messaging.resources.Destination;
import com.solace.messaging.resources.Topic;
import com.solace.messaging.util.CompletionListener;
import com.solace.messaging.util.ManageablePublisher;
import java.io.Serializable;
import java.time.Instant;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface DirectMessagePublisher
extends MessagePublisher {
    @Override
    public ManageablePublisher.DirectPublisherInfo publisherInfo();

    @Override
    public DirectMessagePublisher start();

    public <DirectMessagePublisher> CompletableFuture<DirectMessagePublisher> startAsync() throws PubSubPlusClientException;

    public <DirectMessagePublisher> void startAsync(CompletionListener<DirectMessagePublisher> var1) throws PubSubPlusClientException, IllegalStateException;

    public void setPublishFailureListener(PublishFailureListener var1);

    public void publish(byte[] var1, Topic var2) throws PubSubPlusClientException, IllegalStateException, IllegalArgumentException, PubSubPlusClientException.PublisherOverflowException;

    public void publish(String var1, Topic var2) throws PubSubPlusClientException, IllegalStateException, IllegalArgumentException, PubSubPlusClientException.PublisherOverflowException;

    public void publish(OutboundMessage var1, Topic var2) throws PubSubPlusClientException, IllegalStateException, IllegalArgumentException, PubSubPlusClientException.PublisherOverflowException;

    public void publish(OutboundMessage var1, Topic var2, Properties var3) throws PubSubPlusClientException, IllegalStateException, IllegalArgumentException, PubSubPlusClientException.PublisherOverflowException;

    @ProviderType
    public static class FailedPublishEvent
    implements Serializable {
        private static final long serialVersionUID = -6259777861655945170L;
        private final OutboundMessage message;
        final Destination destination;
        private final long timeStamp;
        private final PubSubPlusClientException exception;

        FailedPublishEvent(OutboundMessage message, Destination destination, PubSubPlusClientException exception, long timeStamp) {
            this.message = message;
            this.destination = destination;
            this.timeStamp = timeStamp;
            this.exception = exception;
        }

        FailedPublishEvent(OutboundMessage message, Destination destination, PubSubPlusClientException exception) {
            this(message, destination, exception, Instant.now().toEpochMilli());
        }

        public OutboundMessage getMessage() {
            return this.message;
        }

        public Destination getDestination() {
            return this.destination;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public PubSubPlusClientException getException() {
            return this.exception;
        }

        public String toString() {
            return "FailedPublishEvent{destination=" + this.destination + ", timeStamp=" + this.timeStamp + ", exception=" + this.exception + '}';
        }
    }

    public static interface PublishFailureListener {
        public void onFailedPublish(FailedPublishEvent var1);
    }
}

