/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.config.provider;

import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.config.SolaceProperties;
import com.solace.messaging.config.profile.SolaceSessionConfiguration;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Dependent;
import com.solace.messaging.util.internal.ExtendedSolaceProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.PropertiesKeyMapping;
import com.solace.messaging.util.internal.Validation;
import com.solacesystems.jcsmp.JCSMPProperties;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public final class ServicePropertiesConverter {
    private static final Map<String, DependentMapping> CONVERTER_MAP_EXTENDED_PROPERTIES;
    private static final Map<String, Mapping> CONVERTER_MAP;

    public static TypedProperties toTypedProperties(Properties properties) {
        Validation.nullIllegal(properties, "Argument properties can't be null");
        TypedProperties.TypedPropertiesImpl output = new TypedProperties.TypedPropertiesImpl();
        Set<String> userPropertyKeys = properties.stringPropertyNames();
        for (String nextKey : userPropertyKeys) {
            Mapping mapping = CONVERTER_MAP.get(nextKey);
            if (mapping == null) continue;
            MappingInfo fieldInfo = mapping.getDirect();
            if (String.class.equals(fieldInfo.getValueType())) {
                output.setProperty(fieldInfo.getPropertyName(), properties.getProperty(nextKey));
                continue;
            }
            if (Integer.TYPE.equals(fieldInfo.getValueType())) {
                String valueMayBeInt = properties.getProperty(nextKey);
                try {
                    output.setIntegerProperty(fieldInfo.getPropertyName(), Integer.parseInt(valueMayBeInt));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Property %s has to be of type integer, can't convert value [%s]", nextKey, valueMayBeInt));
                }
            }
            if (Long.TYPE.equals(fieldInfo.getValueType())) {
                String valueMayBeLong = properties.getProperty(nextKey);
                try {
                    output.setLongProperty(fieldInfo.getPropertyName(), Long.parseLong(valueMayBeLong));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Property %s has to be of type long, can't convert value [%s]", nextKey, valueMayBeLong));
                }
            }
            if (!Boolean.TYPE.equals(fieldInfo.getValueType())) continue;
            String valueMayBeBoolean = properties.getProperty(nextKey);
            output.setBooleanProperty(fieldInfo.getPropertyName(), Boolean.parseBoolean(valueMayBeBoolean));
        }
        return output;
    }

    public static String getInternalSolacePropertyName(String propertyName) {
        Validation.nullIllegal(propertyName, "Argument propertyName can't be null");
        Mapping mapping = CONVERTER_MAP.get(propertyName);
        if (mapping != null) {
            return mapping.getDirect().getPropertyName();
        }
        return null;
    }

    public static TypedProperties validateDependencies(TypedProperties properties) throws PubSubPlusClientException.InvalidConfigurationException {
        CONVERTER_MAP_EXTENDED_PROPERTIES.forEach((key, dependentMapping) -> {
            String expectedDependentPropertyValue;
            String targetPropertyValue = properties.getProperty((String)key);
            Dependency d = dependentMapping.getDependency();
            if (targetPropertyValue != null && d != null && (expectedDependentPropertyValue = properties.getProperty(d.getDependentPropertyName())) != null && !d.getDependentPropertyValue().equals(expectedDependentPropertyValue)) {
                throw new PubSubPlusClientException.InvalidConfigurationException("Property validation failed, expected " + d.getDependentPropertyName() + " to have value " + d.getDependentPropertyValue() + " but was " + expectedDependentPropertyValue);
            }
        });
        return properties;
    }

    public static void mergeAndPostProcessProperties(TypedProperties fromProperties, SolaceSessionConfiguration toProperties) throws PubSubPlusClientException.InvalidConfigurationException {
        if (toProperties == null) {
            throw new IllegalArgumentException("toProperties can't be null");
        }
        if (fromProperties == null) {
            return;
        }
        List<String> riskyProperties = ExtendedSolaceProperties.calculateConflictingProperties(fromProperties);
        for (String riskyProperty : riskyProperties) {
            String v = toProperties.getStringProperty(riskyProperty);
            if (v == null || v.isEmpty()) continue;
            toProperties.remove(riskyProperty);
        }
        ServicePropertiesConverter.postProcessExtendedSolaceProperties(fromProperties);
        fromProperties.propertyNames().forEach(key -> toProperties.setProperty((String)key, fromProperties.getObjectProperty((String)key)));
    }

    private static void postProcessExtendedSolaceProperties(TypedProperties toBePostProcessed) {
        Set<String> allKeys = toBePostProcessed.propertyNames();
        CONVERTER_MAP_EXTENDED_PROPERTIES.forEach((nextKey, m) -> {
            DependentMapping mapping = m;
            if (allKeys.contains(nextKey)) {
                MappingInfo fieldInfo = mapping.getMapping();
                if (String.class.equals(fieldInfo.getValueType())) {
                    toBePostProcessed.setProperty(fieldInfo.getPropertyName(), toBePostProcessed.getProperty((String)nextKey));
                } else if (Integer.TYPE.equals(fieldInfo.getValueType())) {
                    String valueMayBeInt = toBePostProcessed.getProperty((String)nextKey);
                    try {
                        toBePostProcessed.setIntegerProperty(fieldInfo.getPropertyName(), Integer.parseInt(valueMayBeInt));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(String.format("Property %s has to be of type integer, can't convert value [%s]", nextKey, valueMayBeInt));
                    }
                } else if (Long.TYPE.equals(fieldInfo.getValueType())) {
                    String valueMayBeLong = toBePostProcessed.getProperty((String)nextKey);
                    try {
                        toBePostProcessed.setLongProperty(fieldInfo.getPropertyName(), Long.parseLong(valueMayBeLong));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(String.format("Property %s has to be of type long, can't convert value [%s]", nextKey, valueMayBeLong));
                    }
                } else if (Boolean.TYPE.equals(fieldInfo.getValueType())) {
                    String valueMayBeBoolean = toBePostProcessed.getProperty((String)nextKey);
                    toBePostProcessed.setBooleanProperty(fieldInfo.getPropertyName(), Boolean.parseBoolean(valueMayBeBoolean));
                }
                toBePostProcessed.remove((String)nextKey);
            }
        });
    }

    static {
        Class<?>[] innerInterfaces;
        CONVERTER_MAP_EXTENDED_PROPERTIES = new HashMap<String, DependentMapping>();
        CONVERTER_MAP = new HashMap<String, Mapping>();
        for (Class<?> c : innerInterfaces = SolaceProperties.class.getClasses()) {
            for (Field f : c.getDeclaredFields()) {
                int hostFiledModifiers = f.getModifiers();
                if (f.isSynthetic() || !Modifier.isStatic(hostFiledModifiers) || !Modifier.isPublic(hostFiledModifiers) || !Modifier.isFinal(hostFiledModifiers) || !String.class.equals(f.getType())) continue;
                try {
                    PropertiesKeyMapping directMapper = f.getAnnotation(PropertiesKeyMapping.class);
                    if (directMapper == null) continue;
                    String propertyId = (String)f.get(null);
                    try {
                        Class mappedClass = directMapper.mappedClass();
                        if (!JCSMPProperties.class.equals((Object)mappedClass) && !ExtendedSolaceProperties.class.equals((Object)mappedClass)) continue;
                        Field directMappedField = mappedClass.getDeclaredField(directMapper.mappedFieldName());
                        int mappedFiledModifiers = f.getModifiers();
                        if (directMappedField.isSynthetic() || !Modifier.isStatic(mappedFiledModifiers) || !Modifier.isPublic(mappedFiledModifiers) || !Modifier.isFinal(mappedFiledModifiers) || !String.class.equals(directMappedField.getType())) continue;
                        String mappedPropertyValue = (String)directMappedField.get(null);
                        CONVERTER_MAP.put(propertyId, new Mapping(new MappingInfo(directMapper.mappedClass(), directMappedField, mappedPropertyValue, directMapper.valueType(), directMapper.required())));
                    }
                    catch (NoSuchFieldException mappedClass) {}
                }
                catch (IllegalAccessException directMapper) {
                    // empty catch block
                }
            }
        }
        Class<ExtendedSolaceProperties> conditionalExtendedPropertyClass = ExtendedSolaceProperties.class;
        for (Field f : conditionalExtendedPropertyClass.getDeclaredFields()) {
            int hostFiledModifiers = f.getModifiers();
            if (f.isSynthetic() || !Modifier.isStatic(hostFiledModifiers) || !Modifier.isPublic(hostFiledModifiers) || !Modifier.isFinal(hostFiledModifiers) || !String.class.equals(f.getType())) continue;
            try {
                Dependent dependencyMapper = f.getAnnotation(Dependent.class);
                PropertiesKeyMapping directMapper = f.getAnnotation(PropertiesKeyMapping.class);
                if (dependencyMapper == null || directMapper == null) continue;
                String propertyId = (String)f.get(null);
                try {
                    Class mappedClass = directMapper.mappedClass();
                    if (!JCSMPProperties.class.equals((Object)mappedClass)) continue;
                    Field directMappedField = mappedClass.getDeclaredField(directMapper.mappedFieldName());
                    int mappedFiledModifiers = f.getModifiers();
                    if (directMappedField.isSynthetic() || !Modifier.isStatic(mappedFiledModifiers) || !Modifier.isPublic(mappedFiledModifiers) || !Modifier.isFinal(mappedFiledModifiers) || !String.class.equals(directMappedField.getType())) continue;
                    String mappedPropertyValue = (String)directMappedField.get(null);
                    CONVERTER_MAP_EXTENDED_PROPERTIES.put(propertyId, new DependentMapping(new MappingInfo(directMapper.mappedClass(), directMappedField, mappedPropertyValue, directMapper.valueType(), directMapper.required()), new Dependency(dependencyMapper.dependsOnProperty(), dependencyMapper.dependsOnPropertyValue())));
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    @Internal
    public static class MappingInfo {
        final Class<?> hostClass;
        final Field field;
        final String propertyName;
        final Class<?> valueType;
        final boolean required;

        public MappingInfo(Class<?> hostClass, Field field, String propertyName, Class<?> valueType, boolean required) {
            this.hostClass = hostClass;
            this.field = field;
            this.propertyName = propertyName;
            this.valueType = valueType;
            this.required = required;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Class<?> getValueType() {
            return this.valueType;
        }

        public Class<?> getHostClass() {
            return this.hostClass;
        }

        public Field getField() {
            return this.field;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String toString() {
            return "MappingInfo{hostClass=" + this.hostClass + ", field=" + this.field + ", propertyName='" + this.propertyName + '\'' + ", valueType=" + this.valueType + ", required=" + this.required + '}';
        }
    }

    @Internal
    @ProviderType
    public static class Dependency {
        private final String dependentPropertyName;
        private final String dependentPropertyValue;

        public Dependency(String dependentPropertyName, String dependentPropertyValue) {
            this.dependentPropertyName = dependentPropertyName;
            this.dependentPropertyValue = dependentPropertyValue;
        }

        public String getDependentPropertyName() {
            return this.dependentPropertyName;
        }

        public String getDependentPropertyValue() {
            return this.dependentPropertyValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency that = (Dependency)o;
            if (!this.dependentPropertyName.equals(that.dependentPropertyName)) {
                return false;
            }
            return this.dependentPropertyValue.equals(that.dependentPropertyValue);
        }

        public int hashCode() {
            int result = this.dependentPropertyName.hashCode();
            result = 31 * result + this.dependentPropertyValue.hashCode();
            return result;
        }

        public String toString() {
            return "Dependency{dependentPropertyName='" + this.dependentPropertyName + '\'' + ", dependentPropertyValue='" + this.dependentPropertyValue + '\'' + '}';
        }
    }

    @Internal
    @ProviderType
    public static final class DependentMapping {
        final MappingInfo mapping;
        final Dependency dependency;

        public DependentMapping(MappingInfo mapping, Dependency dependency) {
            this.mapping = mapping;
            this.dependency = dependency;
        }

        public Dependency getDependency() {
            return this.dependency;
        }

        public MappingInfo getMapping() {
            return this.mapping;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DependentMapping)) {
                return false;
            }
            DependentMapping that = (DependentMapping)o;
            if (!this.mapping.equals(that.mapping)) {
                return false;
            }
            return this.dependency.equals(that.dependency);
        }

        public int hashCode() {
            int result = this.mapping.hashCode();
            result = 31 * result + this.dependency.hashCode();
            return result;
        }

        public String toString() {
            return "Mapping{mapping=" + this.mapping + '}';
        }
    }

    @Internal
    @ProviderType
    public static final class Mapping {
        final MappingInfo direct;

        public Mapping(MappingInfo direct) {
            this.direct = direct;
        }

        public MappingInfo getDirect() {
            return this.direct;
        }

        public String toString() {
            return "Mapping{direct=" + this.direct + '}';
        }
    }
}

