/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.config;

import com.solace.messaging.config.TypedConfiguration;
import com.solace.messaging.util.SecureStoreFormat;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface TransportSecurityStrategy
extends TypedConfiguration {
    @Override
    @Internal
    default public TypedProperties getConfiguration() {
        return this.getSecurityConfiguration();
    }

    @Internal
    public TypedProperties getSecurityConfiguration();

    @ProviderType
    public static final class TLS
    implements TransportSecurityStrategy {
        private final TypedProperties securityConfiguration = new TypedProperties.TypedPropertiesImpl();

        private TLS() {
            this.securityConfiguration.setBooleanProperty("SSL_VALIDATE_CERTIFICATE", true);
        }

        public static TLS create() {
            return new TLS();
        }

        @Override
        public TypedProperties getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        public TLS withExcludedProtocols(SecureProtocols ... excludedProtocols) {
            if (null != excludedProtocols && 0 < excludedProtocols.length) {
                int excludedProtocolsLength = excludedProtocols.length;
                StringBuilder collector = new StringBuilder(excludedProtocolsLength);
                for (int i = 0; i < excludedProtocolsLength; ++i) {
                    collector.append((Object)excludedProtocols[i]);
                    if (i >= excludedProtocolsLength - 1) continue;
                    collector.append(",");
                }
                this.securityConfiguration.setProperty("SSL_EXCLUDED_PROTOCOLS", collector.toString());
            }
            return this;
        }

        public TLS downgradable() {
            this.securityConfiguration.setProperty("SSL_CONNECTION_DOWNGRADE_TO", "PLAIN_TEXT");
            return this;
        }

        public TLS withoutCertificateValidation() {
            this.securityConfiguration.setBooleanProperty("SSL_VALIDATE_CERTIFICATE", false);
            return this;
        }

        public TLS withCertificateValidation(String trustStorePassword, boolean ignoreExpiration, SecureStoreFormat format, String trustStoreFilePath, String trustedCommonNameList) {
            this.securityConfiguration.setBooleanProperty("SSL_VALIDATE_CERTIFICATE", true);
            this.securityConfiguration.setProperty("SSL_TRUST_STORE_FORMAT", format.toString());
            this.securityConfiguration.setProperty("SSL_TRUST_STORE", trustStoreFilePath);
            this.securityConfiguration.setProperty("SSL_TRUST_STORE_PASSWORD", trustStorePassword);
            this.securityConfiguration.setBooleanProperty("SSL_VALIDATE_CERTIFICATE_DATE", !ignoreExpiration);
            if (trustedCommonNameList != null && !trustedCommonNameList.isEmpty()) {
                this.securityConfiguration.setProperty("SSL_TRUSTED_COMMON_NAME_LIST", trustedCommonNameList);
            }
            return this;
        }

        public TLS withCertificateValidation(String trustStorePassword, boolean ignoreExpiration, SecureStoreFormat format, String trustStoreFilePath) {
            this.securityConfiguration.setBooleanProperty("SSL_VALIDATE_CERTIFICATE", true);
            this.securityConfiguration.setProperty("SSL_TRUST_STORE_FORMAT", format.toString());
            this.securityConfiguration.setProperty("SSL_TRUST_STORE", trustStoreFilePath);
            this.securityConfiguration.setProperty("SSL_TRUST_STORE_PASSWORD", trustStorePassword);
            this.securityConfiguration.setBooleanProperty("SSL_VALIDATE_CERTIFICATE_DATE", !ignoreExpiration);
            return this;
        }

        public TLS withCertificateValidation(String trustStorePassword, boolean ignoreExpiration) {
            this.securityConfiguration.setBooleanProperty("SSL_VALIDATE_CERTIFICATE", true);
            this.securityConfiguration.setProperty("SSL_TRUST_STORE_PASSWORD", trustStorePassword);
            this.securityConfiguration.setProperty("SSL_TRUST_STORE_FORMAT", null);
            this.securityConfiguration.setProperty("SSL_TRUST_STORE", null);
            this.securityConfiguration.setBooleanProperty("SSL_VALIDATE_CERTIFICATE_DATE", !ignoreExpiration);
            return this;
        }

        public TLS withCipherSuites(String cipherSuitesList) {
            this.securityConfiguration.setProperty("SSL_CIPHER_SUITES", cipherSuitesList);
            return this;
        }

        public TLS withoutCertificateHostValidation() {
            this.securityConfiguration.setBooleanProperty("SSL_VALIDATE_CERTIFICATE_HOST", false);
            return this;
        }

        public TLS withCertificateHostValidation() {
            this.securityConfiguration.setBooleanProperty("SSL_VALIDATE_CERTIFICATE_HOST", true);
            return this;
        }

        public static enum SecureProtocols {
            SSLv3{

                public String toString() {
                    return "SSLv3";
                }
            }
            ,
            TLSv1{

                public String toString() {
                    return "TLSv1";
                }
            }
            ,
            TLSv1_1{

                public String toString() {
                    return "TLSv1.1";
                }
            }
            ,
            TLSv1_2{

                public String toString() {
                    return "TLSv1.2";
                }
            };

        }
    }
}

