/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.concurrent;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.internal.core.util.concurrent.ScheduledTaskCapturingEventLoop;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Test;

public class ScheduledTaskCapturingEventLoopTest {
    @Test
    public void should_capture_task_and_let_test_complete_it_manually() {
        ScheduledTaskCapturingEventLoop eventLoop = new ScheduledTaskCapturingEventLoop(null);
        AtomicBoolean ran = new AtomicBoolean();
        ScheduledFuture<?> future = eventLoop.schedule(() -> ran.set(true), 1L, TimeUnit.NANOSECONDS);
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        Assertions.assertThat((boolean)future.isCancelled()).isFalse();
        Assertions.assertThat((boolean)ran.get()).isFalse();
        ScheduledTaskCapturingEventLoop.CapturedTask<?> task = eventLoop.nextTask();
        Assertions.assertThat((long)task.getInitialDelay(TimeUnit.NANOSECONDS)).isEqualTo(1L);
        task.run();
        Assertions.assertThat((boolean)future.isDone()).isTrue();
        Assertions.assertThat((boolean)future.isCancelled()).isFalse();
        Assertions.assertThat((boolean)ran.get()).isTrue();
    }

    @Test
    public void should_let_tested_code_cancel_future() {
        ScheduledTaskCapturingEventLoop eventLoop = new ScheduledTaskCapturingEventLoop(null);
        AtomicBoolean ran = new AtomicBoolean();
        ScheduledFuture<?> future = eventLoop.schedule(() -> ran.set(true), 1L, TimeUnit.NANOSECONDS);
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        Assertions.assertThat((boolean)future.isCancelled()).isFalse();
        Assertions.assertThat((boolean)ran.get()).isFalse();
        future.cancel(true);
        Assertions.assertThat((boolean)future.isDone()).isTrue();
        Assertions.assertThat((boolean)future.isCancelled()).isTrue();
        Assertions.assertThat((boolean)ran.get()).isFalse();
    }
}

