/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.concurrent;

import com.datastax.oss.driver.TestDataProviders;
import com.datastax.oss.driver.api.core.connection.ReconnectionPolicy;
import com.datastax.oss.driver.internal.core.util.concurrent.Reconnection;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import io.netty.channel.EventLoop;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.concurrent.EventExecutor;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=DataProviderRunner.class)
public class ReconnectionTest {
    @Mock
    private ReconnectionPolicy.ReconnectionSchedule reconnectionSchedule;
    @Mock
    private Runnable onStartCallback;
    @Mock
    private Runnable onStopCallback;
    private EmbeddedChannel channel;
    private MockReconnectionTask reconnectionTask;
    private Reconnection reconnection;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.channel = new EmbeddedChannel();
        EventLoop eventExecutor = this.channel.eventLoop();
        this.reconnectionTask = new MockReconnectionTask();
        this.reconnection = new Reconnection("test", (EventExecutor)eventExecutor, () -> this.reconnectionSchedule, (Callable)this.reconnectionTask, this.onStartCallback, this.onStopCallback);
    }

    @Test
    public void should_start_out_not_running() {
        Assertions.assertThat((boolean)this.reconnection.isRunning()).isFalse();
    }

    @Test
    public void should_schedule_first_attempt_on_start() {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofSeconds(1L));
        this.reconnection.start();
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule)).nextDelay();
        Assertions.assertThat((boolean)this.reconnection.isRunning()).isTrue();
        ((Runnable)Mockito.verify((Object)this.onStartCallback)).run();
    }

    @Test
    public void should_ignore_start_if_already_started() {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofSeconds(1L));
        this.reconnection.start();
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule)).nextDelay();
        ((Runnable)Mockito.verify((Object)this.onStartCallback)).run();
        this.reconnection.start();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.reconnectionSchedule, this.onStartCallback});
    }

    @Test
    public void should_stop_if_first_attempt_succeeds() {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        this.reconnection.start();
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule)).nextDelay();
        this.runPendingTasks();
        Assertions.assertThat((int)this.reconnectionTask.callCount()).isEqualTo(1);
        this.reconnectionTask.complete(true);
        this.runPendingTasks();
        Assertions.assertThat((boolean)this.reconnection.isRunning()).isFalse();
        ((Runnable)Mockito.verify((Object)this.onStopCallback)).run();
    }

    @Test
    public void should_reschedule_if_first_attempt_fails() {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        this.reconnection.start();
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule)).nextDelay();
        this.runPendingTasks();
        Assertions.assertThat((int)this.reconnectionTask.callCount()).isEqualTo(1);
        this.reconnectionTask.complete(false);
        this.runPendingTasks();
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule, (VerificationMode)Mockito.times((int)2))).nextDelay();
        this.runPendingTasks();
        Assertions.assertThat((int)this.reconnectionTask.callCount()).isEqualTo(2);
        Assertions.assertThat((boolean)this.reconnection.isRunning()).isTrue();
        this.reconnectionTask.complete(true);
        this.runPendingTasks();
        Assertions.assertThat((boolean)this.reconnection.isRunning()).isFalse();
        ((Runnable)Mockito.verify((Object)this.onStopCallback)).run();
    }

    @Test
    public void should_reconnect_now_if_next_attempt_not_started() {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofDays(1L));
        this.reconnection.start();
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule)).nextDelay();
        this.reconnection.reconnectNow(false);
        this.runPendingTasks();
        Assertions.assertThat((int)this.reconnectionTask.callCount()).isEqualTo(1);
        this.reconnectionTask.complete(false);
        this.runPendingTasks();
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule, (VerificationMode)Mockito.times((int)2))).nextDelay();
    }

    @Test
    public void should_reconnect_now_if_stopped_and_forced() {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofDays(1L));
        Assertions.assertThat((boolean)this.reconnection.isRunning()).isFalse();
        this.reconnection.reconnectNow(true);
        this.runPendingTasks();
        Assertions.assertThat((int)this.reconnectionTask.callCount()).isEqualTo(1);
        this.reconnectionTask.complete(false);
        this.runPendingTasks();
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule)).nextDelay();
    }

    @Test
    @UseDataProvider(location={TestDataProviders.class}, value="booleans")
    public void should_reconnect_now_when_attempt_in_progress(boolean force) {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        this.reconnection.start();
        this.runPendingTasks();
        Assertions.assertThat((int)this.reconnectionTask.callCount()).isEqualTo(1);
        this.reconnection.reconnectNow(force);
        this.runPendingTasks();
        Assertions.assertThat((int)this.reconnectionTask.callCount()).isEqualTo(1);
        Assertions.assertThat((boolean)this.reconnection.isRunning()).isTrue();
        this.reconnectionTask.complete(true);
        this.runPendingTasks();
        Assertions.assertThat((boolean)this.reconnection.isRunning()).isFalse();
    }

    @Test
    public void should_not_reconnect_now_if_stopped_and_not_forced() {
        Assertions.assertThat((boolean)this.reconnection.isRunning()).isFalse();
        this.reconnection.reconnectNow(false);
        this.runPendingTasks();
        Assertions.assertThat((int)this.reconnectionTask.callCount()).isEqualTo(0);
    }

    @Test
    public void should_stop_between_attempts() {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofSeconds(10L));
        this.reconnection.start();
        this.runPendingTasks();
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule)).nextDelay();
        this.reconnection.stop();
        this.runPendingTasks();
        ((Runnable)Mockito.verify((Object)this.onStopCallback)).run();
        Assertions.assertThat((boolean)this.reconnection.isRunning()).isFalse();
    }

    @Test
    public void should_restart_after_stopped_between_attempts() {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofSeconds(10L));
        this.reconnection.start();
        this.runPendingTasks();
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule)).nextDelay();
        this.reconnection.stop();
        this.runPendingTasks();
        Assertions.assertThat((boolean)this.reconnection.isRunning()).isFalse();
        this.reconnection.start();
        this.runPendingTasks();
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule, (VerificationMode)Mockito.times((int)2))).nextDelay();
        Assertions.assertThat((boolean)this.reconnection.isRunning()).isTrue();
    }

    @Test
    @UseDataProvider(location={TestDataProviders.class}, value="booleans")
    public void should_stop_while_attempt_in_progress(boolean outcome) {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        this.reconnection.start();
        this.runPendingTasks();
        Assertions.assertThat((int)this.reconnectionTask.callCount()).isEqualTo(1);
        ((Runnable)Mockito.verify((Object)this.onStartCallback)).run();
        this.reconnection.stop();
        this.runPendingTasks();
        Assertions.assertThat((boolean)this.reconnection.isRunning()).isTrue();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.onStopCallback});
        this.reconnectionTask.complete(outcome);
        this.runPendingTasks();
        ((Runnable)Mockito.verify((Object)this.onStopCallback)).run();
        Assertions.assertThat((boolean)this.reconnection.isRunning()).isFalse();
    }

    @Test
    public void should_restart_after_stopped_while_attempt_in_progress() {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        this.reconnection.start();
        this.runPendingTasks();
        Assertions.assertThat((int)this.reconnectionTask.callCount()).isEqualTo(1);
        ((Runnable)Mockito.verify((Object)this.onStartCallback)).run();
        this.reconnection.stop();
        this.runPendingTasks();
        Assertions.assertThat((boolean)this.reconnection.isRunning()).isTrue();
        this.reconnection.start();
        this.runPendingTasks();
        Assertions.assertThat((boolean)this.reconnection.isRunning()).isTrue();
        Assertions.assertThat((int)this.reconnectionTask.callCount()).isEqualTo(1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.onStartCallback});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.onStopCallback});
        this.reconnectionTask.complete(true);
        this.runPendingTasks();
        Assertions.assertThat((boolean)this.reconnection.isRunning()).isFalse();
        ((Runnable)Mockito.verify((Object)this.onStopCallback)).run();
    }

    private void runPendingTasks() {
        this.channel.runPendingTasks();
    }

    private static class MockReconnectionTask
    implements Callable<CompletionStage<Boolean>> {
        private volatile CompletableFuture<Boolean> nextResult;
        private final AtomicInteger callCount = new AtomicInteger();

        private MockReconnectionTask() {
        }

        @Override
        public CompletionStage<Boolean> call() throws Exception {
            Assertions.assertThat((this.nextResult == null || this.nextResult.isDone() ? 1 : 0) != 0).isTrue();
            this.callCount.incrementAndGet();
            this.nextResult = new CompletableFuture();
            return this.nextResult;
        }

        private void complete(boolean outcome) {
            Assertions.assertThat((this.nextResult != null || !this.nextResult.isDone() ? 1 : 0) != 0).isTrue();
            this.nextResult.complete(outcome);
            this.nextResult = null;
        }

        private int callCount() {
            return this.callCount.get();
        }
    }
}

