/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.concurrent;

import com.datastax.oss.driver.internal.core.util.concurrent.PromiseCombiner;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class PromiseCombinerTest {
    private final EventExecutor executor = ImmediateEventExecutor.INSTANCE;

    @Test
    public void should_complete_normally_if_all_parents_complete_normally() {
        Promise promise = this.executor.newPromise();
        Promise parent1 = this.executor.newPromise();
        Promise parent2 = this.executor.newPromise();
        PromiseCombiner.combine((Promise)promise, (Future[])new Future[]{parent1, parent2});
        parent1.setSuccess(null);
        parent2.setSuccess(null);
        Assertions.assertThat((boolean)promise.isSuccess()).isTrue();
    }

    @Test
    public void should_complete_exceptionally_if_any_parent_completes_exceptionally() {
        Promise promise = this.executor.newPromise();
        Promise parent1 = this.executor.newPromise();
        Promise parent2 = this.executor.newPromise();
        Promise parent3 = this.executor.newPromise();
        NullPointerException npe = new NullPointerException();
        IOException ioe = new IOException();
        PromiseCombiner.combine((Promise)promise, (Future[])new Future[]{parent1, parent2, parent3});
        parent1.setSuccess(null);
        parent2.setFailure((Throwable)npe);
        parent3.setFailure((Throwable)ioe);
        Assertions.assertThat((boolean)promise.isSuccess()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)promise.cause()).isSameAs((Object)npe)).hasSuppressedException((Throwable)ioe);
    }
}

