/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.concurrent;

import com.datastax.oss.driver.internal.core.util.concurrent.CycleDetector;
import com.datastax.oss.driver.internal.core.util.concurrent.LazyReference;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.util.concurrent.ThreadFactoryBuilder;
import com.datastax.oss.driver.shaded.guava.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class CycleDetectorTest {
    @Test
    public void should_detect_cycle_within_same_thread() {
        CycleDetector checker = new CycleDetector("Detected cycle", true);
        CyclicContext context = new CyclicContext(checker, false);
        try {
            context.a.get();
            Assertions.fail((String)"Expected an exception");
        }
        catch (Exception e) {
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Detected cycle");
        }
    }

    @Test
    public void should_detect_cycle_between_different_threads() throws Throwable {
        CycleDetector checker = new CycleDetector("Detected cycle", true);
        CyclicContext context = new CyclicContext(checker, true);
        ExecutorService executor = Executors.newFixedThreadPool(3, new ThreadFactoryBuilder().setNameFormat("thread%d").build());
        Future<String> futureA = executor.submit(() -> (String)context.a.get());
        Future<String> futureB = executor.submit(() -> (String)context.b.get());
        Future<String> futureC = executor.submit(() -> (String)context.c.get());
        context.latchA.countDown();
        context.latchB.countDown();
        context.latchC.countDown();
        for (Future future : ImmutableList.of(futureA, futureB, futureC)) {
            try {
                Uninterruptibles.getUninterruptibly((Future)future);
            }
            catch (ExecutionException e) {
                ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e.getCause()).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Detected cycle");
            }
        }
    }

    private static class CyclicContext {
        private LazyReference<String> a;
        private LazyReference<String> b;
        private LazyReference<String> c;
        private CountDownLatch latchA;
        private CountDownLatch latchB;
        private CountDownLatch latchC;

        private CyclicContext(CycleDetector checker, boolean enableLatches) {
            this.a = new LazyReference("a", this::buildA, checker);
            this.b = new LazyReference("b", this::buildB, checker);
            this.c = new LazyReference("c", this::buildC, checker);
            if (enableLatches) {
                this.latchA = new CountDownLatch(1);
                this.latchB = new CountDownLatch(1);
                this.latchC = new CountDownLatch(1);
            }
        }

        private String buildA() {
            CyclicContext.maybeAwaitUninterruptibly(this.latchA);
            this.b.get();
            return "a";
        }

        private String buildB() {
            CyclicContext.maybeAwaitUninterruptibly(this.latchB);
            this.c.get();
            return "b";
        }

        private String buildC() {
            CyclicContext.maybeAwaitUninterruptibly(this.latchC);
            this.a.get();
            return "c";
        }

        private static void maybeAwaitUninterruptibly(CountDownLatch latch) {
            if (latch != null) {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    Assertions.fail((String)"interrupted", (Throwable)e);
                }
            }
        }
    }
}

