/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.slf4j.LoggerFactory;

public class LoggerTest {
    public static LoggerSetup setupTestLogger(Class<?> clazz, Level levelToCapture) {
        Appender appender = (Appender)Mockito.mock(Appender.class);
        ArgumentCaptor loggingEventCaptor = ArgumentCaptor.forClass(ILoggingEvent.class);
        Logger logger = (Logger)LoggerFactory.getLogger(clazz);
        Level originalLoggerLevel = logger.getLevel();
        logger.setLevel(levelToCapture);
        logger.addAppender(appender);
        return new LoggerSetup(appender, originalLoggerLevel, logger, loggingEventCaptor);
    }

    public static class LoggerSetup {
        private final Level originalLoggerLevel;
        public final Appender<ILoggingEvent> appender;
        public final Logger logger;
        public ArgumentCaptor<ILoggingEvent> loggingEventCaptor;

        private LoggerSetup(Appender<ILoggingEvent> appender, Level originalLoggerLevel, Logger logger, ArgumentCaptor<ILoggingEvent> loggingEventCaptor) {
            this.appender = appender;
            this.originalLoggerLevel = originalLoggerLevel;
            this.logger = logger;
            this.loggingEventCaptor = loggingEventCaptor;
        }

        public void close() {
            this.logger.detachAppender(this.appender);
            this.logger.setLevel(this.originalLoggerLevel);
        }
    }
}

