/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

import com.datastax.oss.driver.internal.core.util.DirectedGraph;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class DirectedGraphTest {
    @Test
    public void should_sort_empty_graph() {
        DirectedGraph g = new DirectedGraph((Object[])new String[0]);
        Assertions.assertThat((List)g.topologicalSort()).isEmpty();
    }

    @Test
    public void should_sort_graph_with_one_node() {
        DirectedGraph g = new DirectedGraph((Object[])new String[]{"A"});
        Assertions.assertThat((List)g.topologicalSort()).containsExactly((Object[])new String[]{"A"});
    }

    @Test
    public void should_sort_complex_graph() {
        DirectedGraph g = new DirectedGraph((Object[])new String[]{"A", "B", "C", "D", "E", "F", "G", "H"});
        g.addEdge((Object)"H", (Object)"F");
        g.addEdge((Object)"G", (Object)"E");
        g.addEdge((Object)"H", (Object)"D");
        g.addEdge((Object)"F", (Object)"D");
        g.addEdge((Object)"G", (Object)"D");
        g.addEdge((Object)"D", (Object)"C");
        g.addEdge((Object)"E", (Object)"C");
        g.addEdge((Object)"D", (Object)"B");
        g.addEdge((Object)"B", (Object)"A");
        Assertions.assertThat((List)g.topologicalSort()).containsExactly((Object[])new String[]{"G", "H", "E", "F", "D", "C", "B", "A"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_sort_if_graph_has_a_cycle() {
        DirectedGraph g = new DirectedGraph((Object[])new String[]{"A", "B", "C"});
        g.addEdge((Object)"A", (Object)"B");
        g.addEdge((Object)"B", (Object)"C");
        g.addEdge((Object)"C", (Object)"B");
        g.topologicalSort();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_sort_if_graph_is_a_cycle() {
        DirectedGraph g = new DirectedGraph((Object[])new String[]{"A", "B", "C"});
        g.addEdge((Object)"A", (Object)"B");
        g.addEdge((Object)"B", (Object)"C");
        g.addEdge((Object)"C", (Object)"A");
        g.topologicalSort();
    }
}

