/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

import com.datastax.oss.driver.internal.core.util.CollectionsUtils;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class CollectionsUtilsTest {
    @Test
    @UseDataProvider(value="listsProvider")
    public void should_combine_two_lists_by_index(List<Integer> firstList, List<Integer> secondList, Map<Integer, Integer> expected) {
        Map result = CollectionsUtils.combineListsIntoOrderedMap(firstList, secondList);
        Assertions.assertThat((Map)result).isEqualTo(expected);
    }

    @Test
    public void should_throw_if_lists_have_not_matching_size() {
        ImmutableList list1 = ImmutableList.of((Object)1);
        ImmutableList list2 = ImmutableList.of((Object)1, (Object)2);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CollectionsUtilsTest.lambda$should_throw_if_lists_have_not_matching_size$0((List)list1, (List)list2)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Cannot combine lists with not matching sizes");
    }

    @DataProvider
    public static Object[][] listsProvider() {
        return new Object[][]{{ImmutableList.of((Object)1), ImmutableList.of((Object)1), ImmutableMap.of((Object)1, (Object)1)}, {ImmutableList.of((Object)1, (Object)10, (Object)5), ImmutableList.of((Object)1, (Object)10, (Object)5), ImmutableMap.of((Object)1, (Object)1, (Object)10, (Object)10, (Object)5, (Object)5)}, {ImmutableList.of((Object)1, (Object)1), ImmutableList.of((Object)1, (Object)2), ImmutableMap.of((Object)1, (Object)2)}};
    }

    private static /* synthetic */ void lambda$should_throw_if_lists_have_not_matching_size$0(List list1, List list2) throws Throwable {
        CollectionsUtils.combineListsIntoOrderedMap((List)list1, (List)list2);
    }
}

