/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.internal.core.util.ArrayUtils;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Test;
import org.mockito.Mockito;

public class ArrayUtilsTest {
    @Test
    public void should_swap() {
        Object[] array = new String[]{"a", "b", "c"};
        ArrayUtils.swap((Object[])array, (int)0, (int)2);
        Assertions.assertThat((Object[])array).containsExactly((Object[])new String[]{"c", "b", "a"});
    }

    @Test
    public void should_swap_with_same_index() {
        Object[] array = new String[]{"a", "b", "c"};
        ArrayUtils.swap((Object[])array, (int)0, (int)0);
        Assertions.assertThat((Object[])array).containsExactly((Object[])new String[]{"a", "b", "c"});
    }

    @Test
    public void should_bubble_up() {
        Object[] array = new String[]{"a", "b", "c", "d", "e"};
        ArrayUtils.bubbleUp((Object[])array, (int)3, (int)1);
        Assertions.assertThat((Object[])array).containsExactly((Object[])new String[]{"a", "d", "b", "c", "e"});
    }

    @Test
    public void should_bubble_up_to_same_index() {
        Object[] array = new String[]{"a", "b", "c", "d", "e"};
        ArrayUtils.bubbleUp((Object[])array, (int)3, (int)3);
        Assertions.assertThat((Object[])array).containsExactly((Object[])new String[]{"a", "b", "c", "d", "e"});
    }

    @Test
    public void should_not_bubble_up_when_target_index_higher() {
        Object[] array = new String[]{"a", "b", "c", "d", "e"};
        ArrayUtils.bubbleUp((Object[])array, (int)3, (int)5);
        Assertions.assertThat((Object[])array).containsExactly((Object[])new String[]{"a", "b", "c", "d", "e"});
    }

    @Test
    public void should_bubble_down() {
        Object[] array = new String[]{"a", "b", "c", "d", "e"};
        ArrayUtils.bubbleDown((Object[])array, (int)1, (int)3);
        Assertions.assertThat((Object[])array).containsExactly((Object[])new String[]{"a", "c", "d", "b", "e"});
    }

    @Test
    public void should_bubble_down_to_same_index() {
        Object[] array = new String[]{"a", "b", "c", "d", "e"};
        ArrayUtils.bubbleDown((Object[])array, (int)3, (int)3);
        Assertions.assertThat((Object[])array).containsExactly((Object[])new String[]{"a", "b", "c", "d", "e"});
    }

    @Test
    public void should_not_bubble_down_when_target_index_lower() {
        Object[] array = new String[]{"a", "b", "c", "d", "e"};
        ArrayUtils.bubbleDown((Object[])array, (int)4, (int)2);
        Assertions.assertThat((Object[])array).containsExactly((Object[])new String[]{"a", "b", "c", "d", "e"});
    }

    @Test
    public void should_shuffle_head() {
        Object[] array = new String[]{"a", "b", "c", "d", "e"};
        ThreadLocalRandom random = (ThreadLocalRandom)Mockito.mock(ThreadLocalRandom.class);
        Mockito.when((Object)random.nextInt(Mockito.anyInt())).thenAnswer(invocation -> {
            int i = (Integer)invocation.getArgument(0);
            return i - 2;
        });
        ArrayUtils.shuffleHead((Object[])array, (int)3, (ThreadLocalRandom)random);
        Assertions.assertThat((String)array[0]).isEqualTo("c");
        Assertions.assertThat((String)array[1]).isEqualTo("a");
        Assertions.assertThat((String)array[2]).isEqualTo("b");
        Assertions.assertThat((String)array[3]).isEqualTo("d");
        Assertions.assertThat((String)array[4]).isEqualTo("e");
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void should_fail_to_shuffle_head_when_count_is_too_high() {
        ArrayUtils.shuffleHead((Object[])new String[]{"a", "b", "c"}, (int)5);
    }

    @Test
    public void should_rotate() {
        Object[] array = new String[]{"a", "b", "c", "d", "e"};
        ArrayUtils.rotate((Object[])array, (int)1, (int)3, (int)1);
        Assertions.assertThat((Object[])array).containsExactly((Object[])new String[]{"a", "c", "d", "b", "e"});
        ArrayUtils.rotate((Object[])array, (int)0, (int)4, (int)2);
        Assertions.assertThat((Object[])array).containsExactly((Object[])new String[]{"d", "b", "a", "c", "e"});
        ArrayUtils.rotate((Object[])array, (int)2, (int)3, (int)10);
        Assertions.assertThat((Object[])array).containsExactly((Object[])new String[]{"d", "b", "c", "e", "a"});
    }

    @Test
    public void should_not_rotate_when_amount_multiple_of_range_size() {
        Object[] array = new String[]{"a", "b", "c", "d", "e"};
        ArrayUtils.rotate((Object[])array, (int)1, (int)3, (int)9);
        Assertions.assertThat((Object[])array).containsExactly((Object[])new String[]{"a", "b", "c", "d", "e"});
    }

    @Test
    public void should_not_rotate_when_range_is_singleton_or_empty() {
        Object[] array = new String[]{"a", "b", "c", "d", "e"};
        ArrayUtils.rotate((Object[])array, (int)1, (int)1, (int)3);
        Assertions.assertThat((Object[])array).containsExactly((Object[])new String[]{"a", "b", "c", "d", "e"});
        ArrayUtils.rotate((Object[])array, (int)1, (int)0, (int)3);
        Assertions.assertThat((Object[])array).containsExactly((Object[])new String[]{"a", "b", "c", "d", "e"});
    }
}

