/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.time;

import com.datastax.oss.driver.api.core.type.codec.ExtraTypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import com.datastax.oss.driver.internal.core.type.codec.TimestampCodecTest;
import com.datastax.oss.driver.internal.core.type.codec.extras.time.ZonedTimestampCodec;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class ZonedTimestampCodecTest
extends CodecTestBase<ZonedDateTime> {
    @Test
    @UseDataProvider(value="timeZones", location={TimestampCodecTest.class})
    public void should_encode(ZoneId timeZone) {
        this.codec = ExtraTypeCodecs.zonedTimestampAt((ZoneId)timeZone);
        Assertions.assertThat((String)this.encode(Instant.EPOCH.atZone(timeZone))).isEqualTo("0x0000000000000000");
        Assertions.assertThat((String)this.encode(Instant.ofEpochMilli(128L).atZone(timeZone))).isEqualTo("0x0000000000000080");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        this.codec = ExtraTypeCodecs.ZONED_TIMESTAMP_UTC;
        Assertions.assertThat((long)((ZonedDateTime)this.decode("0x0000000000000000")).toInstant().toEpochMilli()).isEqualTo(0L);
        Assertions.assertThat((long)((ZonedDateTime)this.decode("0x0000000000000080")).toInstant().toEpochMilli()).isEqualTo(128L);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.decode(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_not_enough_bytes() {
        this.codec = ExtraTypeCodecs.ZONED_TIMESTAMP_SYSTEM;
        this.decode("0x0000");
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_too_many_bytes() {
        this.codec = ExtraTypeCodecs.ZONED_TIMESTAMP_SYSTEM;
        this.decode("0x00000000000000000000");
    }

    @Test
    public void should_format() {
        this.codec = ExtraTypeCodecs.zonedTimestampAt((ZoneId)ZoneOffset.ofHours(2));
        Assertions.assertThat((String)this.format(Instant.EPOCH.atZone(ZoneOffset.UTC))).isEqualTo("'1970-01-01T02:00:00.000+02:00'");
        Assertions.assertThat((String)this.format(ZonedDateTime.parse("2018-08-16T15:59:34.123Z"))).isEqualTo("'2018-08-16T17:59:34.123+02:00'");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    @UseDataProvider(value="timeZones", location={TimestampCodecTest.class})
    public void should_parse(ZoneId timeZone) {
        this.codec = ExtraTypeCodecs.zonedTimestampAt((ZoneId)timeZone);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'0'"))).isEqualTo((Object)Instant.EPOCH.atZone(timeZone));
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'-1'"))).isEqualTo((Object)Instant.EPOCH.minusMillis(1L).atZone(timeZone));
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("1534463100000"))).isEqualTo((Object)Instant.ofEpochMilli(1534463100000L).atZone(timeZone));
        ZonedDateTime expected = LocalDate.parse("2017-01-01").atStartOfDay().atZone(timeZone);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'2017-01-01'"))).isEqualTo((Object)expected);
        expected = LocalDate.parse("2018-08-16").atStartOfDay().atZone(ZoneOffset.ofHours(2));
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'2018-08-16+02'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'2018-08-16+0200'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'2018-08-16+02:00'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'2018-08-16 CEST'"))).isEqualTo((Object)expected);
        expected = LocalDateTime.parse("2018-08-16T23:45").atZone(timeZone);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'2018-08-16T23:45'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'2018-08-16 23:45'"))).isEqualTo((Object)expected);
        expected = LocalDateTime.parse("2019-12-31T16:08:38").atZone(timeZone);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'2019-12-31T16:08:38'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'2019-12-31 16:08:38'"))).isEqualTo((Object)expected);
        expected = LocalDateTime.parse("1950-02-28T12:00:59.230").atZone(timeZone);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1950-02-28T12:00:59.230'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1950-02-28 12:00:59.230'"))).isEqualTo((Object)expected);
        expected = ZonedDateTime.parse("1973-06-23T23:59:00.000+01:00");
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1973-06-23T23:59+01'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1973-06-23T23:59+0100'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1973-06-23T23:59+01:00'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1973-06-23T23:59 CET'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1973-06-23 23:59+01'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1973-06-23 23:59+0100'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1973-06-23 23:59+01:00'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1973-06-23 23:59 CET'"))).isEqualTo((Object)expected);
        expected = ZonedDateTime.parse("1980-01-01T23:59:59.000-08:00");
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1980-01-01T23:59:59-08'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1980-01-01T23:59:59-0800'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1980-01-01T23:59:59-08:00'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1980-01-01T23:59:59 PST'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1980-01-01 23:59:59-08'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1980-01-01 23:59:59-0800'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1980-01-01 23:59:59-08:00'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1980-01-01 23:59:59 PST'"))).isEqualTo((Object)expected);
        expected = ZonedDateTime.parse("1999-12-31T23:59:59.999+00:00");
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1999-12-31T23:59:59.999+00'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1999-12-31T23:59:59.999+0000'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1999-12-31T23:59:59.999+00:00'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1999-12-31T23:59:59.999 UTC'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1999-12-31 23:59:59.999+00'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1999-12-31 23:59:59.999+0000'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1999-12-31 23:59:59.999+00:00'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("'1999-12-31 23:59:59.999 UTC'"))).isEqualTo((Object)expected);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("NULL"))).isNull();
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("null"))).isNull();
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse(""))).isNull();
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse(null))).isNull();
    }

    @Test
    public void should_fail_to_parse_invalid_input() {
        this.codec = new ZonedTimestampCodec();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            ZonedDateTime cfr_ignored_0 = (ZonedDateTime)this.parse("not a timestamp");
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Alphanumeric timestamp literal must be quoted: \"not a timestamp\"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            ZonedDateTime cfr_ignored_0 = (ZonedDateTime)this.parse("'not a timestamp'");
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse timestamp value from \"'not a timestamp'\"");
    }

    @Test
    public void should_accept_generic_type() {
        this.codec = new ZonedTimestampCodec();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(ZonedDateTime.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        this.codec = new ZonedTimestampCodec();
        Assertions.assertThat((boolean)this.codec.accepts(ZonedDateTime.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        this.codec = new ZonedTimestampCodec();
        Assertions.assertThat((boolean)this.codec.accepts((Object)ZonedDateTime.now(ZoneOffset.systemDefault()))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Integer.MIN_VALUE)).isFalse();
    }
}

