/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.time;

import com.datastax.oss.driver.api.core.type.codec.ExtraTypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class PersistentZonedTimestampCodecTest
extends CodecTestBase<ZonedDateTime> {
    private static final ZonedDateTime EPOCH_UTC = Instant.EPOCH.atZone(ZoneOffset.UTC);
    private static final ZonedDateTime EPOCH_MILLIS_CET = Instant.ofEpochMilli(128L).atZone(ZoneId.of("CET"));
    private static final ZonedDateTime EPOCH_MILLIS_OFFSET = Instant.ofEpochMilli(128L).atZone(ZoneOffset.ofHours(2));
    private static final ZonedDateTime EPOCH_MILLIS_EUROPE_PARIS = Instant.ofEpochMilli(-128L).atZone(ZoneId.of("Europe/Paris"));
    private static final String EPOCH_UTC_ENCODED = "0x000000080000000000000000000000015a";
    private static final String EPOCH_MILLIS_CET_ENCODED = "0x00000008000000000000008000000003434554";
    private static final String EPOCH_MILLIS_OFFSET_ENCODED = "0x000000080000000000000080000000062b30323a3030";
    private static final String EPOCH_MILLIS_EUROPE_PARIS_ENCODED = "0x00000008ffffffffffffff800000000c4575726f70652f5061726973";
    private static final String EPOCH_UTC_FORMATTED = "('1970-01-01T00:00:00.000Z','Z')";
    private static final String EPOCH_MILLIS_CET_FORMATTED = "('1970-01-01T00:00:00.128Z','CET')";
    private static final String EPOCH_MILLIS_OFFSET_FORMATTED = "('1970-01-01T00:00:00.128Z','+02:00')";
    private static final String EPOCH_MILLIS_EUROPE_PARIS_FORMATTED = "('1969-12-31T23:59:59.872Z','Europe/Paris')";

    @Before
    public void setup() {
        this.codec = ExtraTypeCodecs.ZONED_TIMESTAMP_PERSISTED;
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode(EPOCH_UTC)).isEqualTo(EPOCH_UTC_ENCODED);
        Assertions.assertThat((String)this.encode(EPOCH_MILLIS_CET)).isEqualTo(EPOCH_MILLIS_CET_ENCODED);
        Assertions.assertThat((String)this.encode(EPOCH_MILLIS_OFFSET)).isEqualTo(EPOCH_MILLIS_OFFSET_ENCODED);
        Assertions.assertThat((String)this.encode(EPOCH_MILLIS_EUROPE_PARIS)).isEqualTo(EPOCH_MILLIS_EUROPE_PARIS_ENCODED);
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.decode(EPOCH_UTC_ENCODED))).isEqualTo((Object)EPOCH_UTC);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.decode(EPOCH_MILLIS_CET_ENCODED))).isEqualTo((Object)EPOCH_MILLIS_CET);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.decode(EPOCH_MILLIS_OFFSET_ENCODED))).isEqualTo((Object)EPOCH_MILLIS_OFFSET);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.decode(EPOCH_MILLIS_EUROPE_PARIS_ENCODED))).isEqualTo((Object)EPOCH_MILLIS_EUROPE_PARIS);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.decode(null))).isNull();
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format(EPOCH_UTC)).isEqualTo(EPOCH_UTC_FORMATTED);
        Assertions.assertThat((String)this.format(EPOCH_MILLIS_CET)).isEqualTo(EPOCH_MILLIS_CET_FORMATTED);
        Assertions.assertThat((String)this.format(EPOCH_MILLIS_OFFSET)).isEqualTo(EPOCH_MILLIS_OFFSET_FORMATTED);
        Assertions.assertThat((String)this.format(EPOCH_MILLIS_EUROPE_PARIS)).isEqualTo(EPOCH_MILLIS_EUROPE_PARIS_FORMATTED);
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse(EPOCH_UTC_FORMATTED))).isEqualTo((Object)EPOCH_UTC);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse(EPOCH_MILLIS_CET_FORMATTED))).isEqualTo((Object)EPOCH_MILLIS_CET);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse(EPOCH_MILLIS_OFFSET_FORMATTED))).isEqualTo((Object)EPOCH_MILLIS_OFFSET);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse(EPOCH_MILLIS_EUROPE_PARIS_FORMATTED))).isEqualTo((Object)EPOCH_MILLIS_EUROPE_PARIS);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("NULL"))).isNull();
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse("null"))).isNull();
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse(""))).isNull();
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.parse(null))).isNull();
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(ZonedDateTime.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(ZonedDateTime.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)ZonedDateTime.now(ZoneOffset.systemDefault()))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Integer.MIN_VALUE)).isFalse();
    }
}

