/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.type.codec.ExtraTypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class FloatArrayCodecTest
extends CodecTestBase<float[]> {
    @Before
    public void setup() {
        this.codec = ExtraTypeCodecs.FLOAT_LIST_TO_ARRAY;
    }

    @Test
    public void should_encode_null() {
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_encode_empty_array() {
        Assertions.assertThat((String)this.encode(new float[0])).isEqualTo("0x00000000");
    }

    @Test
    public void should_encode_non_empty_array() {
        Assertions.assertThat((String)this.encode(new float[]{1.1f, 2.2f, 3.3f})).isEqualTo("0x00000003000000043f8ccccd00000004400ccccd0000000440533333");
    }

    @Test
    public void should_decode_null_as_empty_array() {
        Assertions.assertThat((float[])((float[])this.decode(null))).isEmpty();
    }

    @Test
    public void should_decode_empty_array() {
        Assertions.assertThat((float[])((float[])this.decode("0x00000000"))).isEmpty();
    }

    @Test
    public void should_decode_non_empty_array() {
        Assertions.assertThat((float[])((float[])this.decode("0x00000003000000043f8ccccd00000004400ccccd0000000440533333"))).containsExactly(new float[]{1.1f, 2.2f, 3.3f});
    }

    @Test(expected=NullPointerException.class)
    public void should_not_decode_array_with_null_elements() {
        this.decode("0x00000001FFFFFFFF");
    }

    @Test
    public void should_format_null_array() {
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_format_empty_array() {
        Assertions.assertThat((String)this.format(new float[0])).isEqualTo("[]");
    }

    @Test
    public void should_format_non_empty_array() {
        Assertions.assertThat((String)this.format(new float[]{1.1f, 2.2f, 3.3f})).isEqualTo("[1.1,2.2,3.3]");
    }

    @Test
    public void should_parse_null_or_empty_string() {
        Assertions.assertThat((float[])((float[])this.parse(null))).isNull();
        Assertions.assertThat((float[])((float[])this.parse(""))).isNull();
    }

    @Test
    public void should_parse_empty_array() {
        Assertions.assertThat((float[])((float[])this.parse("[]"))).isEmpty();
    }

    @Test
    public void should_parse_non_empty_array() {
        Assertions.assertThat((float[])((float[])this.parse("[1.1,2.2,3.3]"))).containsExactly(new float[]{1.1f, 2.2f, 3.3f});
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_malformed_array() {
        this.parse("not an array");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Float.TYPE))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Float.class))).isFalse();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(String.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Float.TYPE).getRawType())).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Float.class).getRawType())).isFalse();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(String.class).getRawType())).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)new float[]{1.1f, 2.2f, 3.3f})).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)new Float[]{Float.valueOf(1.1f), Float.valueOf(2.2f), Float.valueOf(3.3f)})).isFalse();
        Assertions.assertThat((boolean)this.codec.accepts((Object)new String[]{"hello", "world"})).isFalse();
    }
}

