/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.type.codec.ExtraTypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class BooleanArrayCodecTest
extends CodecTestBase<boolean[]> {
    @Before
    public void setup() {
        this.codec = ExtraTypeCodecs.BOOLEAN_LIST_TO_ARRAY;
    }

    @Test
    public void should_encode_null() {
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_encode_empty_array() {
        Assertions.assertThat((String)this.encode(new boolean[0])).isEqualTo("0x00000000");
    }

    @Test
    public void should_encode_non_empty_array() {
        Assertions.assertThat((String)this.encode(new boolean[]{true, false})).isEqualTo("0x0000000200000001010000000100");
    }

    @Test
    public void should_decode_null_as_empty_array() {
        Assertions.assertThat((boolean[])((boolean[])this.decode(null))).isEmpty();
    }

    @Test
    public void should_decode_empty_array() {
        Assertions.assertThat((boolean[])((boolean[])this.decode("0x00000000"))).isEmpty();
    }

    @Test
    public void should_decode_non_empty_array() {
        Assertions.assertThat((boolean[])((boolean[])this.decode("0x0000000200000001010000000100"))).containsExactly(new boolean[]{true, false});
    }

    @Test(expected=NullPointerException.class)
    public void should_not_decode_array_with_null_elements() {
        this.decode("0x00000001FFFFFFFF");
    }

    @Test
    public void should_format_null_array() {
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_format_empty_array() {
        Assertions.assertThat((String)this.format(new boolean[0])).isEqualTo("[]");
    }

    @Test
    public void should_format_non_empty_array() {
        Assertions.assertThat((String)this.format(new boolean[]{true, false})).isEqualTo("[true,false]");
    }

    @Test
    public void should_parse_null_or_empty_string() {
        Assertions.assertThat((boolean[])((boolean[])this.parse(null))).isNull();
        Assertions.assertThat((boolean[])((boolean[])this.parse(""))).isNull();
    }

    @Test
    public void should_parse_empty_array() {
        Assertions.assertThat((boolean[])((boolean[])this.parse("[]"))).isEmpty();
    }

    @Test
    public void should_parse_non_empty_array() {
        Assertions.assertThat((boolean[])((boolean[])this.parse("[true,false]"))).containsExactly(new boolean[]{true, false});
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_malformed_array() {
        this.parse("not an array");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Boolean.TYPE))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Boolean.class))).isFalse();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(String.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Boolean.TYPE).getRawType())).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Boolean.class).getRawType())).isFalse();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(String.class).getRawType())).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)new boolean[]{true, false})).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)new Boolean[]{true, false})).isFalse();
        Assertions.assertThat((boolean)this.codec.accepts((Object)new String[]{"hello", "world"})).isFalse();
    }
}

