/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import java.math.BigInteger;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class VarintCodecTest
extends CodecTestBase<BigInteger> {
    public VarintCodecTest() {
        this.codec = TypeCodecs.VARINT;
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode(BigInteger.ONE)).isEqualTo("0x01");
        Assertions.assertThat((String)this.encode(BigInteger.valueOf(128L))).isEqualTo("0x0080");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((BigInteger)((BigInteger)this.decode("0x01"))).isEqualTo((Object)BigInteger.ONE);
        Assertions.assertThat((BigInteger)((BigInteger)this.decode("0x0080"))).isEqualTo((Object)BigInteger.valueOf(128L));
        Assertions.assertThat((BigInteger)((BigInteger)this.decode("0x"))).isNull();
        Assertions.assertThat((BigInteger)((BigInteger)this.decode(null))).isNull();
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format(BigInteger.ONE)).isEqualTo("1");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((BigInteger)((BigInteger)this.parse("1"))).isEqualTo((Object)BigInteger.ONE);
        Assertions.assertThat((BigInteger)((BigInteger)this.parse("NULL"))).isNull();
        Assertions.assertThat((BigInteger)((BigInteger)this.parse("null"))).isNull();
        Assertions.assertThat((BigInteger)((BigInteger)this.parse(""))).isNull();
        Assertions.assertThat((BigInteger)((BigInteger)this.parse(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("not a varint");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(BigInteger.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(BigInteger.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)BigInteger.ONE)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Integer.MIN_VALUE)).isFalse();
    }
}

