/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TimeUuidCodecTest
extends CodecTestBase<UUID> {
    private static final UUID TIME_BASED = new UUID(6342305776366260711L, -5736720392086604862L);
    private static final UUID NOT_TIME_BASED = new UUID(2L, 1L);

    public TimeUuidCodecTest() {
        this.codec = TypeCodecs.TIMEUUID;
        Assertions.assertThat((int)TIME_BASED.version()).isEqualTo(1);
        Assertions.assertThat((int)NOT_TIME_BASED.version()).isNotEqualTo(1);
    }

    @Test
    public void should_encode_time_uuid() {
        Assertions.assertThat((String)this.encode(TIME_BASED)).isEqualTo("0x58046580293811e7b0631332a5f033c2");
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_not_encode_non_time_uuid() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)NOT_TIME_BASED)).isFalse();
        this.encode(NOT_TIME_BASED);
    }

    @Test
    public void should_format_time_uuid() {
        Assertions.assertThat((String)this.format(TIME_BASED)).isEqualTo("58046580-2938-11e7-b063-1332a5f033c2");
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_not_format_non_time_uuid() {
        this.format(NOT_TIME_BASED);
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(UUID.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(UUID.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)TIME_BASED)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Integer.MIN_VALUE)).isFalse();
    }
}

