/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class SmallIntCodecTest
extends CodecTestBase<Short> {
    public SmallIntCodecTest() {
        this.codec = TypeCodecs.SMALLINT;
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode((short)0)).isEqualTo("0x0000");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((Short)((Short)this.decode("0x0000"))).isEqualTo((short)0);
        Assertions.assertThat((Short)((Short)this.decode("0x"))).isNull();
        Assertions.assertThat((Short)((Short)this.decode(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_not_enough_bytes() {
        this.decode("0x00");
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_too_many_bytes() {
        this.decode("0x000000");
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format((short)0)).isEqualTo("0");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((Short)((Short)this.parse("0"))).isEqualTo((short)0);
        Assertions.assertThat((Short)((Short)this.parse("NULL"))).isNull();
        Assertions.assertThat((Short)((Short)this.parse("null"))).isNull();
        Assertions.assertThat((Short)((Short)this.parse(""))).isNull();
        Assertions.assertThat((Short)((Short)this.parse(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("not a smallint");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Short.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Short.TYPE))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(Short.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Short.TYPE)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)123)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Short.MIN_VALUE)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Integer.MIN_VALUE)).isFalse();
    }
}

