/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.util.LinkedHashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class MapCodecTest
extends CodecTestBase<Map<String, Integer>> {
    @Mock
    private TypeCodec<String> keyCodec;
    @Mock
    private TypeCodec<Integer> valueCodec;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.keyCodec.getCqlType()).thenReturn((Object)DataTypes.TEXT);
        Mockito.when((Object)this.keyCodec.getJavaType()).thenReturn((Object)GenericType.STRING);
        Mockito.when((Object)this.valueCodec.getCqlType()).thenReturn((Object)DataTypes.INT);
        Mockito.when((Object)this.valueCodec.getJavaType()).thenReturn((Object)GenericType.INTEGER);
        this.codec = TypeCodecs.mapOf(this.keyCodec, this.valueCodec);
    }

    @Test
    public void should_encode_null() {
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_encode_empty_map() {
        Assertions.assertThat((String)this.encode(new LinkedHashMap())).isEqualTo("0x00000000");
    }

    @Test
    public void should_encode_non_empty_map() {
        Mockito.when((Object)this.keyCodec.encode((Object)"a", ProtocolVersion.DEFAULT)).thenReturn((Object)Bytes.fromHexString((String)"0x10"));
        Mockito.when((Object)this.keyCodec.encode((Object)"b", ProtocolVersion.DEFAULT)).thenReturn((Object)Bytes.fromHexString((String)"0x2000"));
        Mockito.when((Object)this.keyCodec.encode((Object)"c", ProtocolVersion.DEFAULT)).thenReturn((Object)Bytes.fromHexString((String)"0x300000"));
        Mockito.when((Object)this.valueCodec.encode((Object)1, ProtocolVersion.DEFAULT)).thenReturn((Object)Bytes.fromHexString((String)"0x01"));
        Mockito.when((Object)this.valueCodec.encode((Object)2, ProtocolVersion.DEFAULT)).thenReturn((Object)Bytes.fromHexString((String)"0x0002"));
        Mockito.when((Object)this.valueCodec.encode((Object)3, ProtocolVersion.DEFAULT)).thenReturn((Object)Bytes.fromHexString((String)"0x000003"));
        Assertions.assertThat((String)this.encode(ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2, (Object)"c", (Object)3))).isEqualTo("0x00000003000000011000000001010000000220000000000200020000000330000000000003000003");
    }

    @Test
    public void should_decode_null_as_empty_map() {
        Assertions.assertThat((Map)((Map)this.decode(null))).isEmpty();
    }

    @Test
    public void should_decode_empty_map() {
        Assertions.assertThat((Map)((Map)this.decode("0x00000000"))).isEmpty();
    }

    @Test
    public void should_decode_non_empty_map() {
        Mockito.when((Object)((String)this.keyCodec.decode(Bytes.fromHexString((String)"0x10"), ProtocolVersion.DEFAULT))).thenReturn((Object)"a");
        Mockito.when((Object)((String)this.keyCodec.decode(Bytes.fromHexString((String)"0x2000"), ProtocolVersion.DEFAULT))).thenReturn((Object)"b");
        Mockito.when((Object)((String)this.keyCodec.decode(Bytes.fromHexString((String)"0x300000"), ProtocolVersion.DEFAULT))).thenReturn((Object)"c");
        Mockito.when((Object)((Integer)this.valueCodec.decode(Bytes.fromHexString((String)"0x01"), ProtocolVersion.DEFAULT))).thenReturn((Object)1);
        Mockito.when((Object)((Integer)this.valueCodec.decode(Bytes.fromHexString((String)"0x0002"), ProtocolVersion.DEFAULT))).thenReturn((Object)2);
        Mockito.when((Object)((Integer)this.valueCodec.decode(Bytes.fromHexString((String)"0x000003"), ProtocolVersion.DEFAULT))).thenReturn((Object)3);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)((Map)this.decode("0x00000003000000011000000001010000000220000000000200020000000330000000000003000003"))).containsOnlyKeys((Object[])new String[]{"a", "b", "c"}).containsEntry((Object)"a", (Object)1)).containsEntry((Object)"b", (Object)2)).containsEntry((Object)"c", (Object)3);
    }

    @Test
    public void should_decode_map_with_null_elements() {
        Mockito.when((Object)((String)this.keyCodec.decode(Bytes.fromHexString((String)"0x10"), ProtocolVersion.DEFAULT))).thenReturn((Object)"a");
        Mockito.when((Object)((Integer)this.valueCodec.decode(Bytes.fromHexString((String)"0x0002"), ProtocolVersion.DEFAULT))).thenReturn((Object)2);
        ((MapAssert)Assertions.assertThat((Map)((Map)this.decode("0x000000020000000110FFFFFFFFFFFFFFFF000000020002"))).containsOnlyKeys((Object[])new String[]{"a", null}).containsEntry((Object)"a", null)).containsEntry(null, (Object)2);
    }

    @Test
    public void should_format_null_map() {
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_format_empty_map() {
        Assertions.assertThat((String)this.format(new LinkedHashMap())).isEqualTo("{}");
    }

    @Test
    public void should_format_non_empty_map() {
        Mockito.when((Object)this.keyCodec.format((Object)"a")).thenReturn((Object)"foo");
        Mockito.when((Object)this.keyCodec.format((Object)"b")).thenReturn((Object)"bar");
        Mockito.when((Object)this.keyCodec.format((Object)"c")).thenReturn((Object)"baz");
        Mockito.when((Object)this.valueCodec.format((Object)1)).thenReturn((Object)"qux");
        Mockito.when((Object)this.valueCodec.format((Object)2)).thenReturn((Object)"quux");
        Mockito.when((Object)this.valueCodec.format((Object)3)).thenReturn((Object)"quuz");
        Assertions.assertThat((String)this.format(ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2, (Object)"c", (Object)3))).isEqualTo("{foo:qux,bar:quux,baz:quuz}");
    }

    @Test
    public void should_parse_null_or_empty_string() {
        Assertions.assertThat((Map)((Map)this.parse(null))).isNull();
        Assertions.assertThat((Map)((Map)this.parse(""))).isNull();
    }

    @Test
    public void should_parse_empty_map() {
        Assertions.assertThat((Map)((Map)this.parse("{}"))).isEmpty();
    }

    @Test
    public void should_parse_non_empty_map() {
        Mockito.when((Object)((String)this.keyCodec.parse("foo"))).thenReturn((Object)"a");
        Mockito.when((Object)((String)this.keyCodec.parse("bar"))).thenReturn((Object)"b");
        Mockito.when((Object)((String)this.keyCodec.parse("baz"))).thenReturn((Object)"c");
        Mockito.when((Object)((Integer)this.valueCodec.parse("qux"))).thenReturn((Object)1);
        Mockito.when((Object)((Integer)this.valueCodec.parse("quux"))).thenReturn((Object)2);
        Mockito.when((Object)((Integer)this.valueCodec.parse("quuz"))).thenReturn((Object)3);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)((Map)this.parse("{foo:qux,bar:quux,baz:quuz}"))).containsOnlyKeys((Object[])new String[]{"a", "b", "c"}).containsEntry((Object)"a", (Object)1)).containsEntry((Object)"b", (Object)2)).containsEntry((Object)"c", (Object)3);
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_malformed_map() {
        this.parse("not a map");
    }
}

