/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import com.datastax.oss.driver.shaded.guava.common.base.Strings;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class InetCodecTest
extends CodecTestBase<InetAddress> {
    private static final InetAddress V4_ADDRESS;
    private static final InetAddress V6_ADDRESS;

    public InetCodecTest() {
        this.codec = TypeCodecs.INET;
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode(V4_ADDRESS)).isEqualTo("0x7f000001");
        Assertions.assertThat((String)this.encode(V6_ADDRESS)).isEqualTo("0x00000000000000000000000000000001");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((Object)((InetAddress)this.decode("0x7f000001"))).isEqualTo((Object)V4_ADDRESS);
        Assertions.assertThat((Object)((InetAddress)this.decode("0x00000000000000000000000000000001"))).isEqualTo((Object)V6_ADDRESS);
        Assertions.assertThat((Object)((InetAddress)this.decode("0x"))).isNull();
        Assertions.assertThat((Object)((InetAddress)this.decode(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_not_enough_bytes() {
        this.decode("0x0000");
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_incorrect_byte_count() {
        this.decode("0x" + Strings.repeat((String)"00", (int)7));
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_too_many_bytes() {
        this.decode("0x" + Strings.repeat((String)"00", (int)17));
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format(V4_ADDRESS)).isEqualTo("'127.0.0.1'");
        Assertions.assertThat((String)this.format(V6_ADDRESS)).isEqualTo("'0:0:0:0:0:0:0:1'");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((Object)((InetAddress)this.parse("'127.0.0.1'"))).isEqualTo((Object)V4_ADDRESS);
        Assertions.assertThat((Object)((InetAddress)this.parse("'0:0:0:0:0:0:0:1'"))).isEqualTo((Object)V6_ADDRESS);
        Assertions.assertThat((Object)((InetAddress)this.parse("NULL"))).isNull();
        Assertions.assertThat((Object)((InetAddress)this.parse("null"))).isNull();
        Assertions.assertThat((Object)((InetAddress)this.parse(""))).isNull();
        Assertions.assertThat((Object)((InetAddress)this.parse(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("not an address");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(InetAddress.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Inet4Address.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(InetAddress.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Inet4Address.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)V4_ADDRESS)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)V6_ADDRESS)).isTrue();
    }

    static {
        try {
            V4_ADDRESS = InetAddress.getByName("127.0.0.1");
            V6_ADDRESS = InetAddress.getByName("::1");
        }
        catch (UnknownHostException e) {
            Assertions.fail((String)"unexpected error", (Throwable)e);
            throw new AssertionError();
        }
    }
}

