/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class FloatCodecTest
extends CodecTestBase<Float> {
    public FloatCodecTest() {
        this.codec = TypeCodecs.FLOAT;
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode(Float.valueOf(0.0f))).isEqualTo("0x00000000");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((Float)((Float)this.decode("0x00000000"))).isEqualTo(0.0f);
        Assertions.assertThat((Float)((Float)this.decode("0x"))).isNull();
        Assertions.assertThat((Float)((Float)this.decode(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_too_many_bytes() {
        this.decode("0x0000");
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format(Float.valueOf(0.0f))).isEqualTo("0.0");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((Float)((Float)this.parse("0.0"))).isEqualTo(0.0f);
        Assertions.assertThat((Float)((Float)this.parse("NULL"))).isNull();
        Assertions.assertThat((Float)((Float)this.parse("null"))).isNull();
        Assertions.assertThat((Float)((Float)this.parse(""))).isNull();
        Assertions.assertThat((Float)((Float)this.parse(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("not a float");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Float.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Float.TYPE))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(Float.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Float.TYPE)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)Float.valueOf(123.45f))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Float.valueOf(Float.MIN_VALUE))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Integer.MIN_VALUE)).isFalse();
    }
}

