/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class DecimalCodecTest
extends CodecTestBase<BigDecimal> {
    public DecimalCodecTest() {
        this.codec = TypeCodecs.DECIMAL;
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode(BigDecimal.ONE)).isEqualTo("0x0000000001");
        Assertions.assertThat((String)this.encode(BigDecimal.valueOf(128L, 4))).isEqualTo("0x000000040080");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((BigDecimal)((BigDecimal)this.decode("0x0000000001"))).isEqualTo((Object)BigDecimal.ONE);
        Assertions.assertThat((BigDecimal)((BigDecimal)this.decode("0x000000040080"))).isEqualTo((Object)BigDecimal.valueOf(128L, 4));
        Assertions.assertThat((BigDecimal)((BigDecimal)this.decode("0x"))).isNull();
        Assertions.assertThat((BigDecimal)((BigDecimal)this.decode(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_not_enough_bytes() {
        this.decode("0x0000");
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format(BigDecimal.ONE)).isEqualTo("1");
        Assertions.assertThat((String)this.format(BigDecimal.valueOf(128L, 4))).isEqualTo("0.0128");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((BigDecimal)((BigDecimal)this.parse("1"))).isEqualTo((Object)BigDecimal.ONE);
        Assertions.assertThat((BigDecimal)((BigDecimal)this.parse("0.0128"))).isEqualTo((Object)BigDecimal.valueOf(128L, 4));
        Assertions.assertThat((BigDecimal)((BigDecimal)this.parse("NULL"))).isNull();
        Assertions.assertThat((BigDecimal)((BigDecimal)this.parse("null"))).isNull();
        Assertions.assertThat((BigDecimal)((BigDecimal)this.parse(""))).isNull();
        Assertions.assertThat((BigDecimal)((BigDecimal)this.parse(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("not a decimal");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(BigDecimal.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(BigDecimal.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)BigDecimal.ONE)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Integer.MIN_VALUE)).isFalse();
    }
}

