/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import java.time.LocalDate;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class DateCodecTest
extends CodecTestBase<LocalDate> {
    private static final LocalDate EPOCH = LocalDate.ofEpochDay(0L);
    private static final LocalDate MIN = LocalDate.parse("-5877641-06-23");
    private static final LocalDate MAX = LocalDate.parse("+5881580-07-11");

    public DateCodecTest() {
        this.codec = TypeCodecs.DATE;
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode(MIN)).isEqualTo("0x00000000");
        Assertions.assertThat((String)this.encode(EPOCH)).isEqualTo("0x80000000");
        Assertions.assertThat((String)this.encode(MAX)).isEqualTo("0xffffffff");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((LocalDate)((LocalDate)this.decode("0x00000000"))).isEqualTo((Object)MIN);
        Assertions.assertThat((LocalDate)((LocalDate)this.decode("0x80000000"))).isEqualTo((Object)EPOCH);
        Assertions.assertThat((LocalDate)((LocalDate)this.decode("0xffffffff"))).isEqualTo((Object)MAX);
        Assertions.assertThat((LocalDate)((LocalDate)this.decode(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_too_many_bytes() {
        this.decode("0x000000000000");
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format(EPOCH)).isEqualTo("'1970-01-01'");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((LocalDate)((LocalDate)this.parse("0"))).isEqualTo((Object)MIN);
        Assertions.assertThat((LocalDate)((LocalDate)this.parse("2147483648"))).isEqualTo((Object)EPOCH);
        Assertions.assertThat((LocalDate)((LocalDate)this.parse("'-5877641-06-23'"))).isEqualTo((Object)MIN);
        Assertions.assertThat((LocalDate)((LocalDate)this.parse("'1970-01-01'"))).isEqualTo((Object)EPOCH);
        Assertions.assertThat((LocalDate)((LocalDate)this.parse("'2014-01-01'"))).isEqualTo((Object)LocalDate.parse("2014-01-01"));
        Assertions.assertThat((LocalDate)((LocalDate)this.parse("NULL"))).isNull();
        Assertions.assertThat((LocalDate)((LocalDate)this.parse("null"))).isNull();
        Assertions.assertThat((LocalDate)((LocalDate)this.parse(""))).isNull();
        Assertions.assertThat((LocalDate)((LocalDate)this.parse(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("not a date");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(LocalDate.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(LocalDate.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)EPOCH)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Integer.MIN_VALUE)).isFalse();
    }
}

