/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class BigIntCodecTest
extends CodecTestBase<Long> {
    public BigIntCodecTest() {
        this.codec = TypeCodecs.BIGINT;
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode(1L)).isEqualTo("0x0000000000000001");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((Long)((Long)this.decode("0x0000000000000001"))).isEqualTo(1L);
        Assertions.assertThat((Long)((Long)this.decode("0x"))).isNull();
        Assertions.assertThat((Long)((Long)this.decode(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_too_many_bytes() {
        this.decode("0x00000000000000000000");
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format(1L)).isEqualTo("1");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((Long)((Long)this.parse("1"))).isEqualTo(1L);
        Assertions.assertThat((Long)((Long)this.parse("NULL"))).isNull();
        Assertions.assertThat((Long)((Long)this.parse("null"))).isNull();
        Assertions.assertThat((Long)((Long)this.parse(""))).isNull();
        Assertions.assertThat((Long)((Long)this.parse(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("not a number");
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_if_out_of_range() {
        this.parse("92233720368547758070");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Long.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Long.TYPE))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(Long.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Long.TYPE)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)123L)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Long.MIN_VALUE)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Integer.MIN_VALUE)).isFalse();
    }
}

